/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.query.SessionDetailsReport;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class SiriusSessionDetailsPropertyPage
extends PropertyPage {
    private Text text;
    private Session session;
    private Button computeDependenciesButton;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.createSessionDetailsSection(composite);
        this.initialize();
        return composite;
    }

    private void initialize() {
        IResource resourceAird = (IResource)Adapters.adapt((Object)this.getElement(), IResource.class);
        String airdName = String.valueOf(resourceAird.getProject().getName()) + "/" + resourceAird.getProjectRelativePath();
        URI airdURI = URI.createPlatformResourceURI((String)airdName, (boolean)true);
        this.session = SessionManager.INSTANCE.getExistingSession(airdURI);
        if (this.session == null) {
            this.text.setText(Messages.SiriusSessionDetailsPropertyPage_sessionNotOpened);
        } else {
            this.computeSessionDetails(Messages.SiriusSessionDetailsPropertyPage_computeSessionDetails, false);
        }
        this.computeDependenciesButton.setEnabled(this.session != null);
    }

    private String getSessionInformation(boolean computeDependencies) {
        SessionDetailsReport sessionQuery = new SessionDetailsReport(this.session);
        String formattedInformation = sessionQuery.getSessionFormattedInformation(computeDependencies);
        StringBuilder informations = new StringBuilder();
        List openedRepresentations = SessionUIManager.INSTANCE.getUISession(this.session).getEditors().stream().map(editor -> editor.getRepresentation()).collect(Collectors.toList());
        String cr = System.lineSeparator();
        String tab = "  ";
        informations.append(String.valueOf(cr) + MessageFormat.format(Messages.SiriusSessionDetailsPropertyPage_repOpenedInEditor, openedRepresentations.size()) + cr);
        openedRepresentations.stream().forEach(rep -> {
            informations.append(tab);
            if (rep != null) {
                sessionQuery.addRepresentationDescriptorSimpleInfo(informations, new DRepresentationQuery(rep).getRepresentationDescriptor());
            } else {
                informations.append("null");
            }
            informations.append(cr);
        });
        formattedInformation = String.valueOf(formattedInformation) + informations.toString();
        return formattedInformation;
    }

    private void createSessionDetailsSection(Composite parent) {
        Composite sessionDetailsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sessionDetailsComposite.setLayout((Layout)layout);
        sessionDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.computeDependenciesButton = new Button(sessionDetailsComposite, 0);
        this.computeDependenciesButton.setText(Messages.SiriusSessionDetailsPropertyPage_computeDependenciesButton);
        this.computeDependenciesButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.computeDependenciesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String description = Messages.SiriusSessionDetailsPropertyPage_confirmComputingDependenciesDescriptionDialog;
                String title = Messages.SiriusSessionDetailsPropertyPage_confirmComputingDependenciesTitleDialog;
                Shell shell = Display.getCurrent().getActiveShell();
                boolean dialogChoice = MessageDialog.openQuestion((Shell)shell, (String)title, (String)description);
                SiriusSessionDetailsPropertyPage.this.computeSessionDetails(Messages.SiriusSessionDetailsPropertyPage_computeDependenciesSessionDetails, dialogChoice);
                SiriusSessionDetailsPropertyPage.this.computeDependenciesButton.setEnabled(!dialogChoice);
            }
        });
        this.text = new Text(sessionDetailsComposite, 527114);
        this.text.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(JFaceResources.getTextFont());
        this.text.setText(Messages.SiriusSessionDetailsPropertyPage_computingSessionDetails);
        Button copyToClipboard = new Button(sessionDetailsComposite, 0);
        copyToClipboard.setText(Messages.SiriusSessionDetailsPropertyPage_copyToClipboard);
        copyToClipboard.setLayoutData((Object)new GridData(131072, 4, false, false));
        copyToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = null;
                try {
                    clipboard = new Clipboard(SiriusSessionDetailsPropertyPage.this.getShell().getDisplay());
                    clipboard.setContents(new Object[]{SiriusSessionDetailsPropertyPage.this.text.getText()}, new Transfer[]{TextTransfer.getInstance()});
                }
                finally {
                    if (clipboard != null) {
                        clipboard.dispose();
                    }
                }
            }
        });
    }

    private void computeSessionDetails(String jobName, final boolean computeDependencies) {
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                final String sessionInformation = SiriusSessionDetailsPropertyPage.this.getSessionInformation(computeDependencies);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).SiriusSessionDetailsPropertyPage.this.text.isDisposed()) {
                            (this).SiriusSessionDetailsPropertyPage.this.text.setText(sessionInformation);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

