/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RepresentationsSelectionDialog
extends TitleAreaDialog
implements ICheckStateListener {
    private final List<DRepresentation> candidateRepresentations;
    private final List<DRepresentation> selectedRepresentations;
    private CheckboxTableViewer checkList;

    public RepresentationsSelectionDialog(Shell parentShell, Collection<DRepresentation> candidates) {
        super(parentShell);
        this.candidateRepresentations = new ArrayList<DRepresentation>(candidates);
        Collections.sort(this.candidateRepresentations, new Comparator<DRepresentation>(){

            @Override
            public int compare(DRepresentation r1, DRepresentation r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        this.selectedRepresentations = new ArrayList<DRepresentation>(candidates);
    }

    public List<DRepresentation> getSelectedRepresentations() {
        return new ArrayList<DRepresentation>(this.selectedRepresentations);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createSelectionList(composite);
        return composite;
    }

    private void createSelectionList(Composite parent) {
        this.checkList = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.checkList.getTable().setLayoutData((Object)new GridData(1808));
        this.checkList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return RepresentationsSelectionDialog.this.candidateRepresentations.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.checkList.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()));
        this.checkList.addCheckStateListener((ICheckStateListener)this);
        this.checkList.setInput(this.candidateRepresentations);
        this.checkList.setAllChecked(true);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            this.selectedRepresentations.add((DRepresentation)event.getElement());
        } else {
            this.selectedRepresentations.remove(event.getElement());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RepresentationsSelectionDialog_shellTitle);
    }
}

