/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.WorkspaceFileResourceChangeListener;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;

public class WorkspaceResourceChangeListenerImpl
extends WorkspaceFileResourceChangeListener {
    @Override
    public void init() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            WorkspaceFileResourceChangeListener.ResourceDeltaVisitor visitor = this.getResourceDeltaVisitor();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                DiagramUIPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.diagram.ui", e.getMessage()));
            }
            for (String fileURI : visitor.changedFilesURI) {
                this.removeFileStatusAndURIFromMaps(fileURI);
            }
        }
    }
}

