/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.TreeItem;

public class TreeItemLabelFontFormatQuery
extends RunnableWithResult.Impl<List<FontFormat>> {
    private final TreeItem treeItem;
    private int index;

    public TreeItemLabelFontFormatQuery(TreeItem treeItem) {
        this.treeItem = treeItem;
    }

    public TreeItemLabelFontFormatQuery(TreeItem treeItem, int index) {
        this.treeItem = treeItem;
        this.index = index;
    }

    public void run() {
        String dataKey;
        Object styledData;
        ArrayList treeItemLabelFormat = new ArrayList();
        Font font = this.treeItem.getFont(this.index);
        FontData[] fontData = font.getFontData();
        if (fontData.length > 0) {
            int style = fontData[0].getStyle();
            switch (style) {
                case 1: {
                    FontFormatHelper.setFontFormat(treeItemLabelFormat, (FontFormat)FontFormat.BOLD_LITERAL);
                    break;
                }
                case 2: {
                    FontFormatHelper.setFontFormat(treeItemLabelFormat, (FontFormat)FontFormat.ITALIC_LITERAL);
                    break;
                }
                case 3: {
                    FontFormatHelper.setFontFormat(treeItemLabelFormat, (FontFormat)FontFormat.BOLD_LITERAL);
                    FontFormatHelper.setFontFormat(treeItemLabelFormat, (FontFormat)FontFormat.ITALIC_LITERAL);
                    break;
                }
            }
        }
        if ((styledData = this.treeItem.getData(dataKey = "org.eclipse.jfacestyled_label_key_" + this.index)) != null) {
            StyleRange[] styledDataArray = (StyleRange[])styledData;
            StyleRange styleRange = styledDataArray[0];
            if (styleRange.strikeout) {
                FontFormatHelper.setFontFormat(treeItemLabelFormat, (FontFormat)FontFormat.STRIKE_THROUGH_LITERAL);
            }
            if (styleRange.underline) {
                FontFormatHelper.setFontFormat(treeItemLabelFormat, (FontFormat)FontFormat.UNDERLINE_LITERAL);
            }
        }
        this.setResult(treeItemLabelFormat);
    }
}

