/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.item.AnalysisResourceItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointInvalidItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class AnalysisResourceInvalidItemImpl
extends AnalysisResourceItemImpl {
    private Collection<DRepresentationDescriptor> repDescriptors;

    public AnalysisResourceInvalidItemImpl(Session session, Resource resource, Object parent, Collection<DRepresentationDescriptor> repDescriptors) {
        super(session, resource, parent);
        this.repDescriptors = repDescriptors;
    }

    @Override
    public Collection<?> getChildren() {
        LinkedHashMap descriptionToDescriptors = new LinkedHashMap();
        for (DRepresentationDescriptor repDesc : this.repDescriptors) {
            RepresentationDescription description = repDesc.getDescription();
            if (description == null) continue;
            if (descriptionToDescriptors.containsKey(description)) {
                ((List)descriptionToDescriptors.get(description)).add(repDesc);
                continue;
            }
            ArrayList<DRepresentationDescriptor> repDescs = new ArrayList<DRepresentationDescriptor>();
            repDescs.add(repDesc);
            descriptionToDescriptors.put(description, repDescs);
        }
        Set descriptions = descriptionToDescriptors.keySet();
        List all = ((Session)this.getSession().get()).getSelectedViewpoints(false).stream().filter(vp -> this.isVPToBeDisplayed((Viewpoint)vp, descriptions)).map(vp -> new ViewpointInvalidItemImpl((Session)this.getSession().get(), (Viewpoint)vp, this, descriptionToDescriptors)).collect(Collectors.toList());
        Collections.sort(all);
        return all;
    }

    private boolean isVPToBeDisplayed(Viewpoint vp, Set<RepresentationDescription> descriptions) {
        for (RepresentationDescription descriptionInVp : new ViewpointQuery(vp).getAllRepresentationDescriptions()) {
            for (RepresentationDescription representationDescription : descriptions) {
                if (!EqualityHelper.areEquals((EObject)descriptionInVp, (EObject)representationDescription)) continue;
                return true;
            }
        }
        return false;
    }
}

