/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.dialogs;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class SemanticResourceDialog
extends ResourceDialog {
    private static final String SEPARATOR = "  ";

    public SemanticResourceDialog(Shell parent, String title, int style) {
        super(parent, title, style);
    }

    protected boolean processResources() {
        ArrayList<URI> representationFiles = new ArrayList<URI>();
        List urIs = this.getURIs();
        for (URI uri : urIs) {
            if (!new FileQuery(uri.fileExtension()).isSessionResourceFile()) continue;
            representationFiles.add(uri);
        }
        if (!representationFiles.isEmpty()) {
            Status status = new Status(2, "org.eclipse.sirius.ui", MessageFormat.format(Messages.SemanticResourceDialog_representationFilesCantBeAdded_status, representationFiles));
            ErrorDialog.openError((Shell)this.getParentShell(), (String)Messages.SemanticResourceDialog_representationFilesCantBeAdded_title, (String)Messages.SemanticResourceDialog_representationFilesCantBeAdded_message, (IStatus)status);
            Iterables.removeAll((Iterable)urIs, representationFiles);
            if (this.uriField != null && !this.uriField.isDisposed() && !urIs.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (URI uri : urIs) {
                    sb.append(uri);
                    sb.append(SEPARATOR);
                }
                this.uriField.setText(sb.toString().trim());
            }
            return false;
        }
        return true;
    }

    protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
        PotentialSemanticResourceFilter filter = new PotentialSemanticResourceFilter();
        final List<PotentialSemanticResourceFilter> filters = Collections.singletonList(filter);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SemanticResourceDialog.this.isMulti()) {
                    IFile[] files;
                    StringBuffer uris = new StringBuffer();
                    IFile[] iFileArray = files = WorkspaceResourceDialog.openFileSelection((Shell)SemanticResourceDialog.this.getShell(), null, null, (boolean)true, null, (List)filters);
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file = iFileArray[n2];
                        uris.append(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
                        uris.append(SemanticResourceDialog.SEPARATOR);
                        ++n2;
                    }
                    SemanticResourceDialog.this.uriField.setText((String.valueOf(SemanticResourceDialog.this.uriField.getText()) + SemanticResourceDialog.SEPARATOR + uris.toString()).trim());
                } else {
                    IFile file = null;
                    if (SemanticResourceDialog.this.isSave()) {
                        file = WorkspaceResourceDialog.openNewFile((Shell)SemanticResourceDialog.this.getShell(), null, null, null, (List)filters);
                    } else {
                        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)SemanticResourceDialog.this.getShell(), null, null, (boolean)false, null, (List)filters);
                        if (files.length != 0) {
                            file = files[0];
                        }
                    }
                    if (file != null) {
                        SemanticResourceDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                    }
                }
            }
        });
    }

    private static class PotentialSemanticResourceFilter
    extends ViewerFilter {
        private PotentialSemanticResourceFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean isValid = true;
            if (element instanceof IFile) {
                isValid = !new FileQuery((IFile)element).isSessionResourceFile();
            }
            return isValid;
        }
    }
}

