/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.image;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.ui.business.api.image.ITreeImagesContentProvider;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageFiltersUtils;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ImageWorkspaceContentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ImageWorkspaceLabelProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.TreeImagesGalleryComposite;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class ImageSelectionDialog
extends Dialog {
    static final int TREE_WIDTH = 270;
    static final int TREE_HEIGHT = 210;
    private static final String SLASH = "/";
    protected TreeImagesGalleryComposite treeGalleryComposite;
    private String title = Messages.ImageSelectionDialog_title;
    private List<ViewerFilter> filters;
    private Object root = ResourcesPlugin.getWorkspace().getRoot();
    private ITreeImagesContentProvider contentProvider;
    private ILabelProvider labelProvider = new ImageWorkspaceLabelProvider();
    private boolean onlyCloseButton;
    private String currentImagePath;
    private EObject contextObject;
    private Text newPathText;

    public ImageSelectionDialog(Shell parentShell, EObject contextObject, boolean onlyCloseButton, String currentImagePath) {
        super(parentShell);
        this.contentProvider = new ImageWorkspaceContentProvider();
        this.filters = new ArrayList<ViewerFilter>();
        this.filters.add(ImageFiltersUtils.createFileExtensionFilter());
        this.onlyCloseButton = onlyCloseButton;
        if (currentImagePath != null) {
            this.currentImagePath = URI.decode((String)currentImagePath.replace("\\", SLASH));
        }
        this.contextObject = contextObject;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainContainer = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(mainContainer, 0);
        container.setLayout(this.getLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Object folderToSelect = null;
        Object imageToSelect = null;
        if (this.currentImagePath != null) {
            String[] imagePathSegments = this.currentImagePath.split(SLASH);
            Object[] matchingFolder = new Object[1];
            Object[] matchingImage = new Object[1];
            this.computeMatchingFolderAndImage(this.contentProvider.getChildren(this.getRoot()), imagePathSegments, 0, matchingFolder, matchingImage);
            if (matchingImage[0] == null) {
                Object computeImageWithSameName = this.computeImageWithSameName(this.contentProvider.getChildren(this.getRoot()), imagePathSegments[imagePathSegments.length - 1]);
                if (computeImageWithSameName != null) {
                    this.createMessageComposite(container, null, computeImageWithSameName);
                    folderToSelect = this.contentProvider.getParent(computeImageWithSameName);
                    imageToSelect = computeImageWithSameName;
                } else {
                    this.createMessageComposite(container, matchingFolder[0], null);
                    folderToSelect = matchingFolder[0];
                }
            } else {
                folderToSelect = matchingFolder[0];
                imageToSelect = matchingImage[0];
            }
        }
        this.treeGalleryComposite = TreeImagesGalleryComposite.createTreeImagesGalleryComposite(container, this.getLabelProvider(), this.getContentProvider(), this.getFilters(), this.getRoot());
        Tree treeWidget = this.treeGalleryComposite.getViewer().getTree();
        GridData data = (GridData)treeWidget.getLayoutData();
        data.widthHint = 270;
        data.heightHint = 210;
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        this.createImagePathComposite(container);
        this.treeGalleryComposite.setSelection(folderToSelect, imageToSelect);
        return mainContainer;
    }

    private void computeMatchingFolderAndImage(Object[] elements, String[] imagePathSegments, int imagePathIndex, Object[] currentMatchingFolder, Object[] matchingImage) {
        if (imagePathIndex > imagePathSegments.length - 1) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String text = this.labelProvider.getText(object);
            if (imagePathSegments[imagePathIndex].equals(text)) {
                if (imagePathSegments.length == imagePathIndex + 1) {
                    matchingImage[0] = object;
                    break;
                }
                currentMatchingFolder[0] = object;
                this.computeMatchingFolderAndImage(this.contentProvider.getChildren(object), imagePathSegments, imagePathIndex + 1, currentMatchingFolder, matchingImage);
                break;
            }
            ++n2;
        }
    }

    private Object computeImageWithSameName(Object[] elements, String imageName) {
        Object foundImage = null;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String text = this.labelProvider.getText(object);
            if (imageName.equals(text) && this.contentProvider.getImageFile(object).isPresent()) {
                foundImage = object;
                break;
            }
            foundImage = this.computeImageWithSameName(this.contentProvider.getChildren(object), imageName);
            if (foundImage != null) break;
            ++n2;
        }
        return foundImage;
    }

    private void createImagePathComposite(Composite parent) {
        if (this.currentImagePath != null) {
            Composite imagePathContainer = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            imagePathContainer.setLayout((Layout)gridLayout);
            imagePathContainer.setLayoutData((Object)new GridData(4, 4, true, false));
            Label currentPathLabel = new Label(imagePathContainer, 0);
            currentPathLabel.setText("Current image path");
            GridData anyElementData = new GridData();
            anyElementData.horizontalAlignment = 4;
            anyElementData.grabExcessHorizontalSpace = true;
            Text currentPathText = new Text(imagePathContainer, 2048);
            currentPathText.setEditable(false);
            currentPathText.setText(this.currentImagePath);
            currentPathText.setLayoutData((Object)anyElementData);
            Label newPathLabel = new Label(imagePathContainer, 0);
            newPathLabel.setText("New image path");
            this.newPathText = new Text(imagePathContainer, 2048);
            this.newPathText.setEditable(false);
            this.newPathText.setLayoutData((Object)anyElementData);
            this.treeGalleryComposite.getGallery().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedImagePath = ImageSelectionDialog.this.treeGalleryComposite.getSelectedImagePath();
                    selectedImagePath = selectedImagePath != null ? selectedImagePath : "";
                    ImageSelectionDialog.this.newPathText.setText(selectedImagePath);
                }
            });
            this.treeGalleryComposite.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    String selectedImagePath = ImageSelectionDialog.this.treeGalleryComposite.getSelectedImagePath();
                    selectedImagePath = selectedImagePath != null ? selectedImagePath : "";
                    ImageSelectionDialog.this.newPathText.setText(selectedImagePath);
                }
            });
        }
    }

    private void createMessageComposite(Composite parent, Object folderObject, Object imageObject) {
        if (this.currentImagePath != null) {
            Composite messageContainer = new Composite(parent, 4);
            GridLayout gridLayout = new GridLayout(2, false);
            messageContainer.setLayout((Layout)gridLayout);
            Label message = new Label(messageContainer, 0);
            message.setLayoutData((Object)new GridData(4));
            if (folderObject != null) {
                message.setText(MessageFormat.format(Messages.ImageSelectionDialog_imageNotFound_folderFound, new EditingDomainServices().getLabelProviderText(this.contextObject)));
            } else if (imageObject != null) {
                message.setText(MessageFormat.format(Messages.ImageSelectionDialog_imageNotFound_shortNameFound, new EditingDomainServices().getLabelProviderText(this.contextObject)));
            } else {
                message.setText(MessageFormat.format(Messages.ImageSelectionDialog_imageNotFound, new EditingDomainServices().getLabelProviderText(this.contextObject)));
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.onlyCloseButton) {
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
        } else {
            Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            okButton.setEnabled(this.treeGalleryComposite.getSelectedImagePath() != null);
            this.treeGalleryComposite.createListenerForOKButton(okButton);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public boolean close() {
        Job.getJobManager().cancel((Object)TreeImagesGalleryComposite.REFRESH_IMAGE_JOB_FAMILY);
        this.treeGalleryComposite.dispose();
        return super.close();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ViewerFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ViewerFilter> filters) {
        this.filters = filters;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
    }

    public ITreeImagesContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(ITreeImagesContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public String getImagePath() {
        return this.treeGalleryComposite.getSelectedImagePath();
    }
}

