/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.actions.ActionFactory;

public class DTableTreeFocusListener
implements FocusListener {
    private final AbstractDTreeEditor tableEditor;
    private final IAction emfCutAction;
    private final IAction emfCopyAction;
    private final IAction emfPasteAction;
    private final IAction emfDeleteAction;
    private final IAction disabledAction;

    public DTableTreeFocusListener(AbstractDTreeEditor tableEditor, Tree tree) {
        this.tableEditor = tableEditor;
        this.emfCutAction = tableEditor.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
        this.emfCopyAction = tableEditor.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId());
        this.emfPasteAction = tableEditor.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.emfDeleteAction = tableEditor.getActionBars().getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.disabledAction = new DisabledAction();
    }

    public void focusLost(FocusEvent e) {
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.emfCutAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.emfCopyAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.emfPasteAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.emfDeleteAction);
        this.tableEditor.getActionBars().updateActionBars();
    }

    public void focusGained(FocusEvent e) {
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.disabledAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.disabledAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.disabledAction);
        this.tableEditor.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.disabledAction);
        this.tableEditor.getActionBars().updateActionBars();
    }

    private static final class DisabledAction
    extends Action {
        DisabledAction() {
            this.setEnabled(false);
        }
    }
}

