/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.properties.section.description.diagramelementmapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractRadioButtonPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DiagramElementMappingSynchronizationPropertySection
extends AbstractRadioButtonPropertySection {
    private static final String NOT_SYNCHRONIZED_OPTION = "Not synchronized";
    private static final String UNSYNCHRONIZABLE_OPTION = "Unsynchronizable";
    private static final String SYNCHRONIZED_OPTION = "Synchronized";
    private static final String TOOL_TIP = "Defines the level of synchronization of the mapping.\nIf not synchronized, the mapping will be always unsynchronized (createElements=false).\nIf synchronized, the mapping will be always synchronized (createElements=true and synchro lock).\nIf unsynchronizable, the synchronization of the mapping depends on the synchronization mode defined by the user (createElements=true and no synchro lock).";

    protected String getDefaultLabelText() {
        return "Synchronization";
    }

    protected String getLabelText() {
        return super.getLabelText() + ":";
    }

    protected EAttribute getFeature() {
        return null;
    }

    protected Object getFeatureValue(int index) {
        return this.getChoiceOfValues().get(index);
    }

    protected boolean isEqual(int index) {
        String value = DiagramElementMappingSynchronizationPropertySection.convertPropertiesToUI((Boolean)this.eObject.eGet((EStructuralFeature)this.getFeatures().get(0)), (Boolean)this.eObject.eGet((EStructuralFeature)this.getFeatures().get(1)));
        return this.getChoiceOfValues().get(index).equals(value);
    }

    protected List getChoiceOfValues() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(NOT_SYNCHRONIZED_OPTION);
        values.add(UNSYNCHRONIZABLE_OPTION);
        values.add(SYNCHRONIZED_OPTION);
        return values;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.nameLabel.setToolTipText(TOOL_TIP);
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.nameLabel, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setImage(this.getHelpIcon());
        help.setToolTipText(TOOL_TIP);
    }

    public void handleSelectionChanged(int index) {
        boolean equals = this.isEqual(index);
        if (!equals) {
            EditingDomain editingDomain = ((SiriusEditor)this.getPart()).getEditingDomain();
            Object value = this.getFeatureValue(index);
            List<EAttribute> properties = this.getFeatures();
            List<Boolean> propertiesValue = DiagramElementMappingSynchronizationPropertySection.convertUIToProperties((String)value);
            CompoundCommand compoundCommand = new CompoundCommand();
            if (this.eObjectList.size() == 1) {
                int i = 0;
                while (i < properties.size()) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)properties.get(i), (Object)propertiesValue.get(i)));
                    ++i;
                }
            } else {
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)properties.get(0), (Object)propertiesValue.get(0)));
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)properties.get(1), (Object)propertiesValue.get(1)));
                }
            }
            editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    protected String getDefaultFeatureAsText() {
        return DiagramElementMappingSynchronizationPropertySection.convertPropertiesToUI((Boolean)this.eObject.eGet((EStructuralFeature)this.getFeatures().get(0)), (Boolean)this.eObject.eGet((EStructuralFeature)this.getFeatures().get(1)));
    }

    protected List<IItemPropertyDescriptor> getDescriptors() {
        return Collections.emptyList();
    }

    protected List<EAttribute> getFeatures() {
        ArrayList<EAttribute> features = new ArrayList<EAttribute>();
        features.add(DescriptionPackage.eINSTANCE.getDiagramElementMapping_CreateElements());
        features.add(DescriptionPackage.eINSTANCE.getDiagramElementMapping_SynchronizationLock());
        return features;
    }

    public static String convertPropertiesToUI(boolean create, boolean synchroLock) {
        if (!create) {
            return NOT_SYNCHRONIZED_OPTION;
        }
        if (!synchroLock) {
            return UNSYNCHRONIZABLE_OPTION;
        }
        return SYNCHRONIZED_OPTION;
    }

    public static List<Boolean> convertUIToProperties(String label) {
        ArrayList<Boolean> properties = new ArrayList<Boolean>();
        if (NOT_SYNCHRONIZED_OPTION.equals(label)) {
            properties.add(Boolean.FALSE);
            properties.add(Boolean.FALSE);
        } else if (UNSYNCHRONIZABLE_OPTION.equals(label)) {
            properties.add(Boolean.TRUE);
            properties.add(Boolean.FALSE);
        } else if (SYNCHRONIZED_OPTION.equals(label)) {
            properties.add(Boolean.TRUE);
            properties.add(Boolean.TRUE);
        }
        return properties;
    }
}

