/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import java.util.Optional;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class ResourceDeltaQuery {
    private IResourceDelta resourceDelta;

    public ResourceDeltaQuery(IResourceDelta resourceDelta) {
        this.resourceDelta = resourceDelta;
    }

    public boolean hasModelingNatureAdded() {
        return !this.hasModelingNature(this.getOldProjectDescription()) && this.hasModelingNature(this.getNewProjectDescription());
    }

    public boolean hasModelingNatureRemoved() {
        return this.hasModelingNature(this.getOldProjectDescription()) && !this.hasModelingNature(this.getNewProjectDescription());
    }

    private boolean hasModelingNature(Option<IProjectDescription> project) {
        return project.some() && ((IProjectDescription)project.get()).hasNature("org.eclipse.sirius.nature.modelingproject");
    }

    private Option<IProjectDescription> getOldProjectDescription() {
        return this.getProjectDescription(ReflectionHelper.getFieldValueWithoutException((Object)this.resourceDelta, (String)"oldInfo"));
    }

    private Option<IProjectDescription> getNewProjectDescription() {
        return this.getProjectDescription(ReflectionHelper.getFieldValueWithoutException((Object)this.resourceDelta, (String)"newInfo"));
    }

    private Option<IProjectDescription> getProjectDescription(Optional<Object> info) {
        if (info.isPresent() && info.get() instanceof ProjectInfo) {
            ProjectDescription oldProjectDescription = ((ProjectInfo)info.get()).getDescription();
            return Options.fromNullable((Object)oldProjectDescription);
        }
        return Options.newNone();
    }
}

