/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk.migration.description;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.diagram.description.BooleanLayoutOption;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DescriptionFactory;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DoubleLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.elk.Messages;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.osgi.framework.Version;

public class ELK090MigrationParticipant
extends AbstractVSMMigrationParticipant {
    public static final String OLD_OPTION_ID_CONSIDER_MODEL_ORDER = "org.eclipse.elk.layered.considerModelOrder";
    public static final String OLD_OPTION_ID_LABEL_PORT = "org.eclipse.elk.spacing.labelPort";
    public static final String OLD_OPTION_ID_EXPAND_TO_ASPECT_RATIO = "org.eclipse.elk.rectpacking.expandToAspectRatio";
    public static final String OLD_OPTION_ID_EXPAND_NODES = "org.eclipse.elk.expandNodes";
    public static final String OLD_OPTION_ID_LAST_PLACE_SHIFT = "org.eclipse.elk.rectpacking.lastPlaceShift";
    public static final String OLD_OPTION_ID_ONLY_FIRST_ITERATION = "org.eclipse.elk.rectpacking.onlyFirstIteration";
    public static final String OLD_OPTION_ID_OPTIMIZATION_GOAL = "org.eclipse.elk.rectpacking.optimizationGoal";
    public static final String OLD_OPTION_ID_ROW_COMPACTION = "org.eclipse.elk.rectpacking.rowCompaction";
    public static final String OLD_OPTION_ID_TARGET_WIDTH = "org.eclipse.elk.rectpacking.targetWidth";
    public static final Version MIGRATION_VERSION = new Version("15.4.0.202401051836");
    boolean migrationOccured = false;
    StringBuilder migrationMessage = new StringBuilder(Messages.ELK090MigrationParticipant_title);

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    public Object getValue(EObject object, EStructuralFeature feature, Object value, String loadedVersion) {
        String newValue = null;
        if (Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION) < 0 && DescriptionPackage.eINSTANCE.getLayoutOption_Id().equals(feature)) {
            if (object instanceof EnumLayoutOption) {
                if (OLD_OPTION_ID_CONSIDER_MODEL_ORDER.equals(value)) {
                    newValue = LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY.getId();
                } else if (OLD_OPTION_ID_OPTIMIZATION_GOAL.equals(value)) {
                    newValue = RectPackingOptions.WIDTH_APPROXIMATION_OPTIMIZATION_GOAL.getId();
                }
            } else if (object instanceof BooleanLayoutOption) {
                if (OLD_OPTION_ID_LAST_PLACE_SHIFT.equals(value)) {
                    newValue = RectPackingOptions.WIDTH_APPROXIMATION_LAST_PLACE_SHIFT.getId();
                }
            } else if (object instanceof DoubleLayoutOption) {
                if (OLD_OPTION_ID_LABEL_PORT.equals(value)) {
                    newValue = LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL.getId();
                } else if (OLD_OPTION_ID_TARGET_WIDTH.equals(value)) {
                    newValue = RectPackingOptions.WIDTH_APPROXIMATION_TARGET_WIDTH.getId();
                }
            }
        }
        if (newValue != null) {
            return newValue;
        }
        return super.getValue(object, feature, value, loadedVersion);
    }

    protected void postLoad(Group group, Version loadedVersion) {
        group.getOwnedViewpoints().stream().forEach(v -> v.getOwnedRepresentations().stream().filter(DiagramDescription.class::isInstance).map(DiagramDescription.class::cast).forEach(d -> {
            if (d.getLayout() instanceof CustomLayoutConfiguration) {
                CustomLayoutConfiguration customLayoutConfiguration = (CustomLayoutConfiguration)d.getLayout();
                if ("org.eclipse.elk.layered".equals(customLayoutConfiguration.getId())) {
                    ArrayList<DoubleLayoutOption> newOptionsToAdd = new ArrayList<DoubleLayoutOption>();
                    StringBuilder detailMessages = new StringBuilder();
                    for (LayoutOption o : customLayoutConfiguration.getLayoutOptions()) {
                        if (LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL.getId().equals(o.getId())) {
                            DoubleLayoutOption vertical = DescriptionFactory.eINSTANCE.createDoubleLayoutOption();
                            vertical.setId(LayeredOptions.SPACING_LABEL_PORT_VERTICAL.getId());
                            vertical.setValue(((DoubleLayoutOption)o).getValue());
                            newOptionsToAdd.add(vertical);
                            this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_layered_rename_label_port);
                            continue;
                        }
                        if (!LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY.getId().equals(o.getId())) continue;
                        this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_layered_rename_consider_model_order);
                    }
                    customLayoutConfiguration.getLayoutOptions().addAll(newOptionsToAdd);
                    if (!detailMessages.isEmpty()) {
                        this.notifyMigration(this.migrationMessage, (EObject)d, Messages.ELK090MigrationParticipant_layered_title, detailMessages);
                    }
                } else if ("org.eclipse.elk.rectpacking".equals(customLayoutConfiguration.getId())) {
                    StringBuilder detailMessages = new StringBuilder();
                    Iterator iterator = customLayoutConfiguration.getLayoutOptions().iterator();
                    while (iterator.hasNext()) {
                        LayoutOption o = (LayoutOption)iterator.next();
                        if (OLD_OPTION_ID_EXPAND_NODES.equals(o.getId())) {
                            iterator.remove();
                            this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_rectPacking_remove_expandNodes);
                            continue;
                        }
                        if (OLD_OPTION_ID_EXPAND_TO_ASPECT_RATIO.equals(o.getId())) {
                            iterator.remove();
                            this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_rectPacking_remove_expandToAspectRatio);
                            continue;
                        }
                        if (OLD_OPTION_ID_ONLY_FIRST_ITERATION.equals(o.getId())) {
                            iterator.remove();
                            this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_rectPacking_remove_onlyFirstIteration);
                            continue;
                        }
                        if (OLD_OPTION_ID_ROW_COMPACTION.equals(o.getId())) {
                            iterator.remove();
                            this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_rectPacking_remove_rowCompaction);
                            continue;
                        }
                        if (RectPackingOptions.WIDTH_APPROXIMATION_OPTIMIZATION_GOAL.getId().equals(o.getId())) {
                            this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_rectPacking_rename_optimization_goal);
                            continue;
                        }
                        if (RectPackingOptions.WIDTH_APPROXIMATION_LAST_PLACE_SHIFT.getId().equals(o.getId())) {
                            this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_rectPacking_rename_last_place_shift);
                            continue;
                        }
                        if (!RectPackingOptions.WIDTH_APPROXIMATION_TARGET_WIDTH.getId().equals(o.getId())) continue;
                        this.notifyMigration(detailMessages, Messages.ELK090MigrationParticipant_rectPacking_rename_target_width);
                    }
                    if (!detailMessages.isEmpty()) {
                        this.notifyMigration(this.migrationMessage, (EObject)d, Messages.ELK090MigrationParticipant_rectPacking_title, detailMessages);
                    }
                }
            }
        }));
        if (this.migrationOccured) {
            DiagramPlugin.getDefault().logInfo(this.migrationMessage.toString());
            this.migrationOccured = false;
            this.migrationMessage = new StringBuilder(Messages.ELK090MigrationParticipant_title);
        }
    }

    private void notifyMigration(StringBuilder detailMessages, String messageTemplate) {
        this.migrationOccured = true;
        detailMessages.append("\n");
        detailMessages.append(messageTemplate);
    }

    private void notifyMigration(StringBuilder mainMessage, EObject diagramDescription, String messageTemplate, StringBuilder detailMessages) {
        this.migrationOccured = true;
        String diagramDescriptionLabel = "unknown";
        if (diagramDescription instanceof DiagramDescription) {
            diagramDescriptionLabel = new IdentifiedElementQuery((IdentifiedElement)((DiagramDescription)diagramDescription)).getLabel();
        }
        mainMessage.append("\n");
        mainMessage.append(MessageFormat.format(messageTemplate, diagramDescriptionLabel));
        mainMessage.append((CharSequence)detailMessages);
    }
}

