/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import java.util.Collections;
import java.util.Set;
import org.eclipse.sirius.tests.swtbot.support.api.business.UILocalSession;
import org.eclipse.sirius.tests.swtbot.support.api.condition.ItemEnabledCondition;
import org.eclipse.sirius.tests.swtbot.support.api.dialog.ViewpointSelectionDialog;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;

public class SemanticResourceFromSratchWizardUIWrapper {
    private final SWTBotShell newPage;
    private final ViewpointSelectionDialog selectionDialog;

    public SemanticResourceFromSratchWizardUIWrapper(UILocalSession uiLocalSession, SWTBotShell newPage) {
        this.newPage = newPage;
        this.selectionDialog = new ViewpointSelectionDialog(uiLocalSession.bot);
    }

    public SemanticResourceFromSratchWizardUIWrapper selectDirecltyMetamodelURI(String nsURI) {
        SWTBot bot = this.newPage.bot();
        SWTBotCombo comboBox = bot.comboBox();
        comboBox.setFocus();
        comboBox.setSelection(nsURI);
        return this;
    }

    public SemanticResourceFromSratchWizardUIWrapper selectRootModelElementToUse(String rootModelElementName) {
        SWTBot bot = this.newPage.bot();
        SWTBotCombo swtBotCombo = bot.comboBox(1);
        swtBotCombo.setFocus();
        swtBotCombo.setText(rootModelElementName);
        return this;
    }

    public SemanticResourceFromSratchWizardUIWrapper setSemanticResourceFileName(String semanticResourceFileName) {
        SWTBot bot = this.newPage.bot();
        SWTBotText textBot = bot.text(0);
        textBot.setFocus();
        textBot.setText(semanticResourceFileName);
        return this;
    }

    public void finishWithViewpointSelection(Set<String> viewpointsToSelect) {
        SWTBot bot = this.newPage.bot();
        SWTBotButton button = bot.button("Finish");
        bot.waitUntil((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)button));
        button.click();
        this.selectionDialog.selectViewpoint(viewpointsToSelect, Collections.emptySet());
        bot.waitUntil(Conditions.shellCloses((SWTBotShell)this.newPage));
    }
}

