/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.PropertyBinding;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.PlexusBeanManager;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusLifecycleManager
implements PlexusBeanManager,
Module {
    private static final Class<?>[] LIFECYCLE_TYPES;
    private static final boolean HAS_PROVISION_LISTENER;
    private final ThreadLocal<List<?>[]> pendingHolder = new ThreadLocal();
    private final List<Startable> startableBeans = new ArrayList<Startable>();
    private final List<Disposable> disposableBeans = new ArrayList<Disposable>();
    private final Logger consoleLogger = new ConsoleLogger();
    private final Provider<Context> plexusContextProvider;
    private final Provider<LoggerManager> plexusLoggerManagerProvider;
    private final Provider<?> slf4jLoggerFactoryProvider;

    static {
        boolean hasProvisionListener;
        try {
            hasProvisionListener = ProvisionListener.class.isInterface();
        }
        catch (LinkageError linkageError) {
            hasProvisionListener = false;
        }
        HAS_PROVISION_LISTENER = hasProvisionListener;
        LIFECYCLE_TYPES = new Class[]{LogEnabled.class, Contextualizable.class, Initializable.class, Startable.class, Disposable.class};
    }

    public PlexusLifecycleManager(Provider<Context> plexusContextProvider, Provider<LoggerManager> plexusLoggerManagerProvider, Provider<?> slf4jLoggerFactoryProvider) {
        this.plexusContextProvider = plexusContextProvider;
        this.plexusLoggerManagerProvider = plexusLoggerManagerProvider;
        this.slf4jLoggerFactoryProvider = slf4jLoggerFactoryProvider;
    }

    public void configure(Binder binder) {
        if (HAS_PROVISION_LISTENER) {
            binder.bindListener(Matchers.any(), new ProvisionListener[]{new PlexusProvisionListener()});
        }
    }

    @Override
    public boolean manage(Class<?> clazz) {
        Class<?>[] classArray = LIFECYCLE_TYPES;
        int n = LIFECYCLE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> lifecycleType = classArray[n2];
            if (lifecycleType.isAssignableFrom(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PropertyBinding manage(final BeanProperty property) {
        Class clazz = property.getType().getRawType();
        if ("org.slf4j.Logger".equals(clazz.getName())) {
            return new PropertyBinding(){

                public <B> void injectProperty(B bean) {
                    property.set(bean, PlexusLifecycleManager.this.getSLF4JLogger(bean));
                }
            };
        }
        if (Logger.class.equals((Object)clazz)) {
            return new PropertyBinding(){

                public <B> void injectProperty(B bean) {
                    property.set(bean, (Object)PlexusLifecycleManager.this.getPlexusLogger(bean));
                }
            };
        }
        return null;
    }

    @Override
    public boolean manage(Object bean) {
        if (bean instanceof Disposable) {
            PlexusLifecycleManager.synchronizedAdd(this.disposableBeans, (Disposable)bean);
        }
        if (bean instanceof LogEnabled) {
            ((LogEnabled)bean).enableLogging(this.getPlexusLogger(bean));
        }
        if (bean instanceof Contextualizable || bean instanceof Initializable || bean instanceof Startable) {
            if (HAS_PROVISION_LISTENER) {
                List<?>[] holder = this.getPendingHolder();
                List<?> beans = holder[0];
                if (beans == null || beans.isEmpty()) {
                    beans = new ArrayList();
                    holder[0] = beans;
                }
                beans.add(bean);
            } else {
                this.manageLifecycle(bean);
            }
        }
        return true;
    }

    @Override
    public boolean unmanage(Object bean) {
        if (PlexusLifecycleManager.synchronizedRemove(this.startableBeans, bean)) {
            this.stop((Startable)bean);
        }
        if (PlexusLifecycleManager.synchronizedRemove(this.disposableBeans, bean)) {
            this.dispose((Disposable)bean);
        }
        return true;
    }

    @Override
    public boolean unmanage() {
        Object bean;
        while ((bean = PlexusLifecycleManager.synchronizedRemoveLast(this.startableBeans)) != null) {
            this.stop((Startable)bean);
        }
        while ((bean = PlexusLifecycleManager.synchronizedRemoveLast(this.disposableBeans)) != null) {
            this.dispose((Disposable)bean);
        }
        this.pendingHolder.remove();
        return true;
    }

    public PlexusBeanManager manageChild() {
        return this;
    }

    Logger getPlexusLogger(Object bean) {
        String name = bean.getClass().getName();
        try {
            return ((LoggerManager)this.plexusLoggerManagerProvider.get()).getLoggerForComponent(name, null);
        }
        catch (RuntimeException runtimeException) {
            return this.consoleLogger;
        }
    }

    Object getSLF4JLogger(Object bean) {
        String name = bean.getClass().getName();
        try {
            return ((ILoggerFactory)this.slf4jLoggerFactoryProvider.get()).getLogger(name);
        }
        catch (RuntimeException runtimeException) {
            return LoggerFactory.getLogger((String)name);
        }
    }

    List<?>[] getPendingHolder() {
        List<?>[] holder = this.pendingHolder.get();
        if (holder == null) {
            holder = new List[1];
            this.pendingHolder.set(holder);
        }
        return holder;
    }

    void manageLifecycle(Object bean) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = bean.getClass();
            while (clazz != null) {
                ClassLoader loader = clazz.getClassLoader();
                if (loader instanceof URLClassLoader) {
                    Thread.currentThread().setContextClassLoader(loader);
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            if (bean instanceof Contextualizable) {
                this.contextualize((Contextualizable)bean);
            }
            if (bean instanceof Initializable) {
                this.initialize((Initializable)bean);
            }
            if (bean instanceof Startable) {
                Startable startableBean = (Startable)bean;
                PlexusLifecycleManager.synchronizedAdd(this.startableBeans, startableBean);
                this.start(startableBean);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> boolean synchronizedAdd(List<T> list, T element) {
        List<T> list2 = list;
        synchronized (list2) {
            return list.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean synchronizedRemove(List<?> list, Object element) {
        List<?> list2 = list;
        synchronized (list2) {
            return list.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T synchronizedRemoveLast(List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            int size = list.size();
            if (size > 0) {
                return list.remove(size - 1);
            }
            return null;
        }
    }

    private void contextualize(Contextualizable bean) {
        Logs.trace((String)"Contextualize: <>", (Object)bean, null);
        try {
            bean.contextualize((Context)this.plexusContextProvider.get());
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Error contextualizing: " + Logs.identityToString((Object)bean), e);
            }
            finally {
                Logs.throwUnchecked((Throwable)e);
            }
        }
    }

    private void initialize(Initializable bean) {
        Logs.trace((String)"Initialize: <>", (Object)bean, null);
        try {
            bean.initialize();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Error initializing: " + Logs.identityToString((Object)bean), e);
            }
            finally {
                Logs.throwUnchecked((Throwable)e);
            }
        }
    }

    private void start(Startable bean) {
        Logs.trace((String)"Start: <>", (Object)bean, null);
        try {
            bean.start();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Error starting: " + Logs.identityToString((Object)bean), e);
            }
            finally {
                Logs.throwUnchecked((Throwable)e);
            }
        }
    }

    private void stop(Startable bean) {
        Logs.trace((String)"Stop: <>", (Object)bean, null);
        try {
            bean.stop();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Problem stopping: " + Logs.identityToString((Object)bean), e);
            }
            catch (Throwable throwable) {}
            return;
        }
    }

    private void dispose(Disposable bean) {
        Logs.trace((String)"Dispose: <>", (Object)bean, null);
        try {
            bean.dispose();
        }
        catch (Throwable e) {
            Logs.catchThrowable((Throwable)e);
            try {
                this.getPlexusLogger(this).warn("Problem disposing: " + Logs.identityToString((Object)bean), e);
            }
            catch (Throwable throwable) {}
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PlexusProvisionListener
    implements ProvisionListener {
        PlexusProvisionListener() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> pi) {
            List<?>[] holder = PlexusLifecycleManager.this.getPendingHolder();
            if (holder[0] == null) {
                List<?> beans;
                holder[0] = Collections.EMPTY_LIST;
                try {
                    pi.provision();
                }
                finally {
                    beans = holder[0];
                    holder[0] = null;
                }
                int i = 0;
                int size = beans.size();
                while (i < size) {
                    PlexusLifecycleManager.this.manageLifecycle(beans.get(i));
                    ++i;
                }
            }
        }
    }
}

