/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractFileLoadOperation;

public class FileUnloadOperation
extends AbstractFileLoadOperation {
    private boolean memoryOptimized;

    public FileUnloadOperation(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized) {
        super(Messages.job_unloadingModelResources, files, mmDescriptor);
        this.memoryOptimized = memoryOptimized;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.runDetectAndUnloadModelFiles(this.getFiles(), this.getMetaModelDescriptor(), this.memoryOptimized, monitor);
    }

    protected void runDetectAndUnloadModelFiles(Collection<IFile> files, IMetaModelDescriptor mmDescriptor, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_unloadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        Map<TransactionalEditingDomain, Collection<IFile>> filesToUnload = this.detectFilesToUnload(files, mmDescriptor, (IProgressMonitor)progress.newChild(10));
        if (filesToUnload.size() == 0) {
            progress.done();
            return;
        }
        this.runUnloadModelFiles(filesToUnload, memoryOptimized, (IProgressMonitor)progress.newChild(90));
    }
}

