/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.actions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.examples.actions.internal.Activator;
import org.eclipse.sphinx.examples.actions.internal.messages.Messages;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectStatisticsAction
extends BaseSelectionListenerAction {
    public ProjectStatisticsAction() {
        super(Messages.act_ProjectStatistics_label);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IProject) {
            IProject project = (IProject)selection.getFirstElement();
            return ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project).size() > 0;
        }
        return false;
    }

    public void run() {
        IProject project = null;
        final HashMap objectsPerType = new HashMap();
        final int[] totalObjects = new int[1];
        final int[] totalResources = new int[1];
        if (this.getStructuredSelection().getFirstElement() instanceof IProject) {
            project = (IProject)this.getStructuredSelection().getFirstElement();
            for (final IModelDescriptor modelDescriptor : ModelDescriptorRegistry.INSTANCE.getModels((IContainer)project)) {
                try {
                    modelDescriptor.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            for (Resource resource : modelDescriptor.getLoadedResources(true)) {
                                totalResources[0] = totalResources[0] + 1;
                                TreeIterator allContent = resource.getAllContents();
                                while (allContent.hasNext()) {
                                    EObject eObject = (EObject)allContent.next();
                                    Class<?> type = eObject.getClass();
                                    HashSet<EObject> objects = (HashSet<EObject>)objectsPerType.get(type);
                                    if (objects == null) {
                                        objects = new HashSet<EObject>();
                                        objectsPerType.put(type, objects);
                                    }
                                    if (!objects.add(eObject)) continue;
                                    totalObjects[0] = totalObjects[0] + 1;
                                }
                            }
                        }
                    });
                }
                catch (Exception exception) {}
            }
            String fileName = "Statistic.txt";
            if (project.getFile(fileName).exists()) {
                InputDialog dialog = new InputDialog(ExtendedPlatformUI.getActiveShell(), Messages.dlg_ProjectStatistics_fileAlreadyExists_title, Messages.dlg_ProjectStatistics_fileAlreadyExists_desc, fileName, null);
                dialog.setBlockOnOpen(true);
                int result = dialog.open();
                fileName = result == 0 ? dialog.getValue() : null;
            }
            if (fileName != null) {
                try {
                    this.writeStatisticReport(project, objectsPerType, totalObjects[0], fileName, totalResources[0]);
                    project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    IFile file = project.getFile(fileName);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                }
                catch (Exception ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                }
            }
        }
    }

    private void writeStatisticReport(IProject project, Map<Class<?>, Set<Object>> objectsPerType, int totalObjects, String fileName, int totalFile) throws IOException {
        FileWriter fw = new FileWriter(String.valueOf(project.getLocation().toOSString()) + File.separator + fileName);
        PrintWriter out = new PrintWriter(fw);
        String message = NLS.bind((String)Messages.act_ProjectStatistics_result_ProjectName, (Object)project.getName());
        out.println(message);
        message = NLS.bind((String)Messages.act_ProjectStatistics_result_Summary, (Object[])new Object[]{totalObjects, objectsPerType.size(), totalFile});
        out.println(message);
        String format = "| %1$-10s| %2$-100s|\n";
        out.printf(format, Messages.act_ProjectStatistics_result_columLabel_Quantity, Messages.act_ProjectStatistics_result_columLabel_Type);
        for (Class<?> type : objectsPerType.keySet()) {
            out.printf(format, objectsPerType.get(type).size(), type.getCanonicalName());
        }
        out.print(Messages.act_ProjectStatistics_result_eof);
        out.close();
    }
}

