/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.sphinx.platform.ui.fields.BasicHyperlinkField;
import org.eclipse.sphinx.platform.ui.fields.IStringField;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;

public class HyperlinkStringField
extends BasicHyperlinkField
implements IStringField {
    private String fText = "";
    private Text fTextControl;
    private ModifyListener fModifyListener;
    private boolean fEditable = true;
    private int fStyle = -1;

    private int getStyle() {
        if (this.fStyle == -1) {
            this.fStyle = 4;
            if (!this.fUseFormLayout) {
                this.fStyle |= 0x800;
            }
        }
        return this.fStyle;
    }

    public HyperlinkStringField(IWidgetFactory widgetFactory, HyperlinkAdapter hyperlinkAdapter) {
        super(widgetFactory, hyperlinkAdapter);
    }

    public HyperlinkStringField(IWidgetFactory widgetFactory, HyperlinkAdapter hyperlinkAdapter, int style) {
        this(widgetFactory, hyperlinkAdapter);
        this.fStyle = style;
        this.fEditable = true;
    }

    @Override
    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Control label = this.getLabelControl(parent, 1);
        Text text = this.getTextControl(parent, nColumns - 1);
        return new Control[]{label, text};
    }

    protected final Text getTextControl(Composite parent, int hspan) {
        Text text = this.createTextControl(parent, hspan);
        if (text.getLayoutData() == null) {
            if (this.fUseFormLayout) {
                text.setLayoutData((Object)LayoutUtil.tableWrapDataForText(hspan));
            } else {
                text.setLayoutData((Object)LayoutUtil.gridDataForText(hspan));
            }
        }
        return text;
    }

    private Text createTextControl(Composite parent, int hspan) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HyperlinkStringField.this.doModifyText(e);
                }
            };
            this.fTextControl = this.fWidgetFactory != null ? this.fWidgetFactory.createText(parent, hspan, true) : new Text(parent, this.getStyle());
            this.fTextControl.setText(this.fText);
            this.fTextControl.setFont(parent.getFont());
            this.fTextControl.addModifyListener(this.fModifyListener);
            this.fTextControl.setEnabled(this.isEnabled());
            this.fTextControl.setEditable(this.fEditable);
        }
        return this.fTextControl;
    }

    @Override
    protected int getNumberOfControls() {
        return 2;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setFocus();
            this.fTextControl.setSelection(0, this.fTextControl.getText().length());
        }
        return true;
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fText = this.fTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.dispose();
        }
    }

    @Override
    public String getText() {
        return this.fText;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
        this.updateEditableState();
    }

    @Override
    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextEnabled(boolean b) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(b);
        }
    }

    @Override
    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.removeModifyListener(this.fModifyListener);
            this.fTextControl.setText(text);
            this.fTextControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    public Control getTextControl() {
        Text control = null;
        if (this.isOkToUse((Control)this.fTextControl)) {
            control = this.fTextControl;
        }
        return control;
    }

    @Override
    public void setEditable(boolean editable) {
        if (editable != this.fEditable) {
            this.fEditable = editable;
            this.updateEditableState();
        }
    }

    protected void updateEditableState() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEditable(this.fEditable);
        }
    }

    protected final boolean isEditable() {
        return this.fEditable;
    }
}

