/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.launching;

import java.io.FileNotFoundException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.cli.AbstractCLIApplication;
import org.eclipse.sphinx.platform.cli.ICommonCLIConstants;
import org.eclipse.sphinx.platform.launching.ILauncherCLIConstants;
import org.eclipse.sphinx.platform.launching.internal.messages.Messages;

public class BasicLauncherApplication
extends AbstractCLIApplication {
    protected String getCommandLineSyntax() {
        return String.format(ICommonCLIConstants.COMMAND_LINE_SYNTAX_FORMAT_WITH_WORKSPACE, "org.eclipse.sphinx.platform.launching.Launcher");
    }

    protected void defineOptions() {
        super.defineOptions();
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)ILauncherCLIConstants.OPTION_LAUNCH_ARG_NAME);
        OptionBuilder.withDescription((String)ILauncherCLIConstants.OPTION_LAUNCH_DESCRIPTION);
        this.addOption(OptionBuilder.create((String)"launch"));
    }

    protected Object interrogate() throws Throwable {
        super.interrogate();
        CommandLine commandLine = this.getCommandLine();
        String launchOptionValue = commandLine.getOptionValue("launch");
        IFile launchFile = this.getLaunchFile(launchOptionValue);
        ILaunchConfiguration launchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(launchFile);
        launchConfiguration.launch("run", this.createProgressMonitor());
        return ERROR_NO;
    }

    protected IFile getLaunchFile(String launchOptionValue) throws FileNotFoundException {
        Path launchPath = new Path(launchOptionValue);
        IFile launchFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)launchPath);
        if (!launchFile.exists()) {
            IPath launchLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append((IPath)launchPath);
            throw new FileNotFoundException(NLS.bind((String)Messages.error_launchFileDoesNotExist, (Object)launchLocation.toOSString()));
        }
        return launchFile;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }
}

