/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ecore.proxymanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolver;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolverService;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.services.AbstractMetaModelService;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSet;

public abstract class AbstractProxyResolverService
extends AbstractMetaModelService
implements IProxyResolverService {
    private List<IProxyResolver> proxyResolvers = new ArrayList<IProxyResolver>();

    public AbstractProxyResolverService(Collection<IMetaModelDescriptor> mmDescriptors) {
        super(mmDescriptors);
        this.initProxyResolvers();
    }

    protected abstract void initProxyResolvers();

    protected EClass getTargetEClass(URI uri) {
        return null;
    }

    protected List<IProxyResolver> getProxyResolvers() {
        if (this.proxyResolvers == null) {
            this.proxyResolvers = new ArrayList<IProxyResolver>();
        }
        return this.proxyResolvers;
    }

    protected IProxyResolver getProxyResolver(EClass eType) {
        for (IProxyResolver resolver : this.getProxyResolvers()) {
            if (!resolver.canResolve(eType)) continue;
            return resolver;
        }
        return null;
    }

    @Override
    public EObject getEObject(EObject proxy, EObject contextObject, boolean loadOnDemand) {
        IProxyResolver proxyResolver = this.getProxyResolver(proxy.eClass());
        if (proxyResolver != null) {
            return proxyResolver.getEObject(proxy, contextObject, loadOnDemand);
        }
        return null;
    }

    @Override
    public EObject getEObject(URI uri, ExtendedResourceSet contextResourceSet, Object contextObject, boolean loadOnDemand) {
        IProxyResolver proxyResolver;
        EClass targetEClass = this.getTargetEClass(uri);
        if (targetEClass != null && (proxyResolver = this.getProxyResolver(targetEClass)) != null) {
            return proxyResolver.getEObject(uri, targetEClass, contextResourceSet, contextObject, loadOnDemand);
        }
        return null;
    }
}

