/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.common.ui.perspectives;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class SphinxPerspectiveFactory
implements IPerspectiveFactory {
    public void createInitialLayout(IPageLayout layout) {
        this.createLayout(layout);
        this.addNewWizardShortcuts(layout);
        this.addShowViewShortcuts(layout);
        this.addOpenPerspectiveShortcuts(layout);
        this.addActionSets(layout);
        this.addShowInParts(layout);
    }

    private void createLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        int relativePos = 1;
        IFolderLayout topLeft = layout.createFolder("topLeft", relativePos, 0.2f, editorArea);
        topLeft.addView("org.eclipse.sphinx.examples.explorer.views.modelExplorer");
        topLeft.addView("org.eclipse.ui.navigator.ProjectExplorer");
        relativePos = 4;
        IFolderLayout bottomRight = layout.createFolder("bottomRight", relativePos, 0.65f, editorArea);
        bottomRight.addView("org.eclipse.ui.views.PropertySheet");
        bottomRight.addView("org.eclipse.sphinx.examples.validation.ui.views.validation");
        bottomRight.addView("org.eclipse.pde.runtime.LogView");
        bottomRight.addPlaceholder("org.eclipse.ui.views.ProblemView");
        bottomRight.addPlaceholder("org.eclipse.ui.console.ConsoleView");
    }

    private void addNewWizardShortcuts(IPageLayout layout) {
        layout.addNewWizardShortcut("org.eclipse.sphinx.examples.common.ui.newWizards.linkedFile");
        layout.addNewWizardShortcut("org.eclipse.sphinx.examples.common.ui.newWizards.linkedFolder");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
    }

    private void addShowViewShortcuts(IPageLayout layout) {
        layout.addShowViewShortcut("org.eclipse.sphinx.examples.explorer.views.modelExplorer");
        layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        layout.addShowViewShortcut("org.eclipse.sphinx.examples.validation.ui.views.validation");
        layout.addShowViewShortcut("org.eclipse.pde.runtime.LogView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
    }

    private void addOpenPerspectiveShortcuts(IPageLayout layout) {
        layout.addPerspectiveShortcut("org.eclipse.ui.resourcePerspective");
    }

    private void addActionSets(IPageLayout layout) {
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        layout.addActionSet("org.eclipse.team.ui.actionSet");
    }

    private void addShowInParts(IPageLayout layout) {
        layout.addShowInPart("org.eclipse.sphinx.examples.explorer.views.modelExplorer");
        layout.addShowInPart("org.eclipse.ui.navigator.ProjectExplorer");
    }
}

