/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.referentialintegrity;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeListener;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class URIChangeListenerRegistry {
    public static URIChangeListenerRegistry INSTANCE = new URIChangeListenerRegistry();
    private Set<IURIChangeListener> fURIChangeListeners = new HashSet<IURIChangeListener>();
    private static final String EXTP_URI_CHANGE_LISTENERS = "org.eclipse.sphinx.emf.workspace.uriChangeListeners";
    private static final String NODE_LISTENER = "listener";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_OVERRIDE = "override";

    private URIChangeListenerRegistry() {
        this.readContributedURIChangeListeners();
    }

    public Set<IURIChangeListener> getListeners() {
        return this.fURIChangeListeners;
    }

    private void readContributedURIChangeListeners() {
        IConfigurationElement[] configElements;
        IExtension extension;
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTP_URI_CHANGE_LISTENERS).getExtensions();
        HashSet<String> overriddenIds = new HashSet<String>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            extension = iExtensionArray[n2];
            configElements = extension.getConfigurationElements();
            overriddenIds.addAll(this.getOverriddenURIChangeListenerIds(configElements));
            ++n2;
        }
        iExtensionArray = extensions;
        n = extensions.length;
        n2 = 0;
        while (n2 < n) {
            extension = iExtensionArray[n2];
            configElements = extension.getConfigurationElements();
            this.readContributedURIChangeListeners(configElements, overriddenIds);
            ++n2;
        }
    }

    private void readContributedURIChangeListeners(IConfigurationElement[] configElements, Set<String> overriddenIds) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                String id = configElement.getAttribute(ATTR_ID);
                if (!overriddenIds.contains(id)) {
                    IURIChangeListener listener = (IURIChangeListener)configElement.createExecutableExtension(ATTR_CLASS);
                    this.addListener(listener);
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
            }
            ++n2;
        }
    }

    public void addListener(IURIChangeListener listener) {
        if (listener != null) {
            this.fURIChangeListeners.add(listener);
        }
    }

    public void removeListener(IURIChangeListener listener) {
        if (listener != null) {
            this.fURIChangeListeners.remove(listener);
        }
    }

    private Set<String> getOverriddenURIChangeListenerIds(IConfigurationElement[] configElements) {
        Assert.isNotNull((Object)configElements);
        HashSet<String> overriddenIds = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            String overriddenURIChangeDetectorDelegateId;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (NODE_LISTENER.equals(configElement.getName()) && (overriddenURIChangeDetectorDelegateId = configElement.getAttribute(ATTR_OVERRIDE)) != null) {
                if (!overriddenIds.contains(overriddenURIChangeDetectorDelegateId)) {
                    overriddenIds.add(overriddenURIChangeDetectorDelegateId);
                } else {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(NLS.bind((String)Messages.warning_multipleOverridesForSameURIChangeListener, (Object)overriddenURIChangeDetectorDelegateId)));
                }
            }
            ++n2;
        }
        return overriddenIds;
    }
}

