/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.editor;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSetSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.compare.ui.ModelElementCompareInput;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelCompareEditor;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.compare.ui.viewer.content.ModelElementContentMergeViewer;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.navigator.SaveablesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementCompareEditorInput
extends ModelCompareEditorInput
implements ISaveablesSource {
    private EObject[] modelRoots;
    protected SaveablesProvider modelSaveablesProvider;
    protected TransactionalEditingDomain editingDomain;

    public ModelElementCompareEditorInput(ComparisonSnapshot snapshot) {
        super(snapshot);
    }

    protected MatchModel getMatchModel() {
        Object matchModel = null;
        if (this.preparedInput != null) {
            matchModel = this.preparedInput.getMatch();
        } else if (this.inputSnapshot != null) {
            if (this.inputSnapshot instanceof ComparisonResourceSnapshot) {
                matchModel = ((ComparisonResourceSnapshot)this.inputSnapshot).getMatch();
            } else if (this.inputSnapshot instanceof ComparisonResourceSetSnapshot) {
                matchModel = ((ComparisonResourceSetSnapshot)this.inputSnapshot).getMatchResourceSet();
            }
        } else {
            Status warning = new Status(2, Activator.getPlugin().getSymbolicName(), Messages.warning_inputsNull, (Throwable)new NullPointerException());
            PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)warning);
        }
        return matchModel instanceof MatchModel ? (MatchModel)matchModel : null;
    }

    protected Map<?, ?> getSaveOptions() {
        return EcoreResourceUtil.getDefaultSaveOptions();
    }

    public boolean isDirty() {
        boolean isDirty = false;
        EObject[] eObjectArray = this.getModelRoots();
        int n = eObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            EObject modelRoot = eObjectArray[n2];
            if (modelRoot instanceof EObject) {
                isDirty = isDirty || ModelSaveManager.INSTANCE.isDirty(modelRoot.eResource());
            }
            ++n2;
        }
        return isDirty;
    }

    protected void init() {
        if (this.modelSaveablesProvider == null) {
            this.modelSaveablesProvider = this.createModelSaveablesProvider();
            if (this.getWorkbenchPart() instanceof ModelCompareEditor) {
                ISaveablesLifecycleListener modelSaveablesLifecycleListener = ((ModelCompareEditor)this.getWorkbenchPart()).createModelSaveablesLifecycleListener();
                this.modelSaveablesProvider.init(modelSaveablesLifecycleListener);
            } else if (this.getWorkbenchPart() == null) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new NullPointerException(Messages.warning_workbenchPartNull));
            } else {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(Messages.warning_workbenchPartInstanceofModelCompareEditor));
            }
        }
    }

    public EObject[] getModelRoots() {
        MatchModel matchModel;
        if (this.modelRoots == null) {
            this.modelRoots = new EObject[2];
        }
        if ((matchModel = this.getMatchModel()) != null) {
            if (this.modelRoots[0] == null || this.modelRoots[0].eIsProxy() || this.modelRoots[0].eResource() == null || !this.modelRoots[0].eResource().isLoaded()) {
                EList leftRoots = matchModel.getLeftRoots();
                this.modelRoots[0] = (EObject)leftRoots.get(0);
            }
            if (this.modelRoots[1] == null || this.modelRoots[1].eIsProxy() || this.modelRoots[1].eResource() == null || !this.modelRoots[1].eResource().isLoaded()) {
                EList rightRoots = matchModel.getRightRoots();
                this.modelRoots[1] = (EObject)rightRoots.get(0);
            }
        } else {
            Status warning = new Status(2, Activator.getPlugin().getSymbolicName(), Messages.warning_inputMatchModelNull, (Throwable)new NullPointerException());
            PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)warning);
        }
        return this.modelRoots;
    }

    protected ModelContentMergeViewer createMergeViewer(CompareViewerPane pane, CompareConfiguration compareConfig) {
        return new ModelElementContentMergeViewer((Composite)pane, compareConfig);
    }

    protected ModelCompareInput createModelCompareInput(ComparisonSnapshot snap) {
        if (snap instanceof ComparisonResourceSetSnapshot) {
            return new ModelElementCompareInput(((ComparisonResourceSetSnapshot)snap).getMatchResourceSet(), ((ComparisonResourceSetSnapshot)snap).getDiffResourceSet());
        }
        return new ModelElementCompareInput(((ComparisonResourceSnapshot)snap).getMatch(), ((ComparisonResourceSnapshot)snap).getDiff());
    }

    protected SaveablesProvider createModelSaveablesProvider() {
        return new BasicModelSaveablesProvider();
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        this.init();
        Object input = super.prepareInput(monitor);
        String leftLabel = this.getLeftLabel();
        String rightLabel = this.getRightLabel();
        String ancestorLabel = this.getAncestorLabel();
        String title = ancestorLabel == null ? NLS.bind((String)Messages.twoWay_title, (Object)leftLabel, (Object)rightLabel) : NLS.bind((String)Messages.threeWay_title, (Object[])new String[]{ancestorLabel, leftLabel, rightLabel});
        this.setTitle(title);
        return input;
    }

    protected String getRightLabel() {
        EObject rightRoot = this.getModelRoots()[1];
        Resource rightResource = this.preparedInput.getRightResource();
        EObject rightModelRoot = EcoreResourceUtil.getModelRoot((Resource)rightResource);
        String rightLabel = rightResource.getURI().toPlatformString(true);
        if (rightRoot != rightModelRoot) {
            String fragment = rightResource.getURIFragment(rightRoot);
            fragment = fragment.lastIndexOf("?") == -1 ? "" : fragment.substring(0, fragment.lastIndexOf("?"));
            rightLabel = rightLabel.concat("#" + fragment);
        }
        return rightLabel;
    }

    protected String getLeftLabel() {
        EObject leftRoot = this.getModelRoots()[0];
        Resource leftResource = this.preparedInput.getLeftResource();
        EObject leftModelRoot = EcoreResourceUtil.getModelRoot((Resource)leftResource);
        String leftLabel = leftResource.getURI().toPlatformString(true);
        if (leftRoot != leftModelRoot) {
            String fragment = leftResource.getURIFragment(leftRoot);
            fragment = fragment.lastIndexOf("?") == -1 ? "" : fragment.substring(0, fragment.lastIndexOf("?"));
            leftLabel = leftLabel.concat("#" + fragment);
        }
        return leftLabel;
    }

    protected String getAncestorLabel() {
        Resource ancestorResource = this.preparedInput.getAncestorResource();
        if (ancestorResource != null) {
            return ancestorResource.getURI().toString();
        }
        return null;
    }

    public String getToolTipText() {
        if (this.preparedInput != null) {
            String leftLabel = this.getLeftLabel();
            String rightLabel = this.getRightLabel();
            String ancestorLabel = this.getAncestorLabel();
            if (ancestorLabel == null) {
                return NLS.bind((String)Messages.twoWay_tooltip, (Object)leftLabel, (Object)rightLabel);
            }
            return NLS.bind((String)Messages.threeWay_tooltip, (Object[])new Object[]{ancestorLabel, leftLabel, rightLabel});
        }
        return super.getToolTipText();
    }

    public void saveChanges(IProgressMonitor monitor) {
        EObject[] eObjectArray = this.getModelRoots();
        int n = eObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            EObject modelRoot = eObjectArray[n2];
            if (modelRoot instanceof EObject) {
                ModelSaveManager.INSTANCE.saveModel(modelRoot.eResource(), this.getSaveOptions(), false, monitor);
            }
            ++n2;
        }
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public Saveable[] getSaveables() {
        HashSet<Saveable> saveables = new HashSet<Saveable>();
        if (this.modelSaveablesProvider != null) {
            Saveable rightSaveable;
            Saveable leftSaveable = this.modelSaveablesProvider.getSaveable((Object)this.getModelRoots()[0].eResource());
            if (leftSaveable != null) {
                saveables.add(leftSaveable);
            }
            if ((rightSaveable = this.modelSaveablesProvider.getSaveable((Object)this.getModelRoots()[1].eResource())) != null) {
                saveables.add(rightSaveable);
            }
        }
        return saveables.toArray(new Saveable[saveables.size()]);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public TransactionalEditingDomain setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        return this.editingDomain;
    }

    protected void finalize() throws Throwable {
        if (this.modelSaveablesProvider != null) {
            this.modelSaveablesProvider.dispose();
            this.modelSaveablesProvider = null;
        }
        if (this.editingDomain != null) {
            this.editingDomain.dispose();
        }
        super.finalize();
    }
}

