/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.util;

import java.util.Map;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.util.LabeledRunnable;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class ModelOperationRunner {
    public static void performModelAccess(Resource affectedResource, Runnable runnable) throws CoreException {
        Assert.isNotNull((Object)runnable);
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)affectedResource);
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(runnable);
            }
            catch (InterruptedException ex) {
                throw new CoreException(StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex));
            }
        } else {
            runnable.run();
        }
    }

    public static <T> T performModelAccess(Resource affectedResource, RunnableWithResult<T> runnable) throws CoreException {
        Assert.isNotNull(runnable);
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)affectedResource);
        if (editingDomain != null) {
            try {
                return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, runnable);
            }
            catch (InterruptedException ex) {
                throw new CoreException(StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex));
            }
        }
        runnable.run();
        return (T)runnable.getResult();
    }

    public static void performModelModification(Resource affectedResource, LabeledRunnable runnable) throws CoreException {
        ModelOperationRunner.performModelModification(affectedResource, runnable, true);
    }

    public static void performModelModification(Resource affectedResource, LabeledRunnable runnable, boolean affectsDirtyState) throws CoreException {
        Assert.isNotNull((Object)runnable);
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)affectedResource);
        if (editingDomain != null) {
            boolean wasDirtyBefore = SaveIndicatorUtil.isDirty((EditingDomain)editingDomain, (Resource)affectedResource);
            try {
                IOperationHistory operationHistory = WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain);
                Map options = WorkspaceTransactionUtil.getDefaultTransactionOptions();
                options.put("no_undo", affectsDirtyState ? Boolean.FALSE : Boolean.TRUE);
                WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)runnable, (String)runnable.getLabel(), (IOperationHistory)operationHistory, (Map)options, null);
            }
            catch (OperationCanceledException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CoreException(StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex));
            }
            if (!wasDirtyBefore && !affectsDirtyState) {
                SaveIndicatorUtil.unsetDirty((EditingDomain)editingDomain, (Resource)affectedResource);
            }
        } else {
            runnable.run();
        }
    }
}

