/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.resources;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.mwe.core.resources.AbstractResourceLoader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;

public class BasicWorkspaceResourceLoader
extends AbstractResourceLoader
implements IWorkspaceResourceLoader {
    protected static final String DEFAULT_TEMPLATE_FOLDER_NAME = "template";
    protected static final String DEFAULT_EXTENSION_FOLDER_NAME = "extension";
    protected static final String DEFAULT_CHECK_FOLDER_NAME = "check";
    protected IProject contextProject = null;
    protected IModelDescriptor contextModel = null;
    protected Set<IProject> projectsInScope = new HashSet<IProject>();
    protected ClassLoader workspaceClassLoader = null;
    protected boolean searchArchives = true;

    @Override
    public IProject getContextProject() {
        return this.contextProject;
    }

    @Override
    public void setContextProject(IProject contextProject) {
        this.resetContext();
        this.contextProject = contextProject;
    }

    @Override
    public IModelDescriptor getContextModel() {
        return this.contextModel;
    }

    @Override
    public void setContextModel(IModelDescriptor contextModel) {
        this.resetContext();
        this.contextModel = contextModel;
    }

    @Override
    public void setSearchArchives(boolean searchArchives) {
        if (this.searchArchives != searchArchives) {
            this.workspaceClassLoader = null;
        }
        this.searchArchives = searchArchives;
    }

    protected void resetContext() {
        this.contextProject = null;
        this.contextModel = null;
        this.projectsInScope.clear();
        this.workspaceClassLoader = null;
    }

    protected Collection<IProject> getProjectsInScope() {
        if (this.projectsInScope.isEmpty()) {
            if (this.contextProject != null) {
                this.projectsInScope.add(this.contextProject);
            } else if (this.contextModel != null) {
                this.projectsInScope.addAll(this.collectReachableProjects(this.contextModel));
            }
        }
        return this.projectsInScope;
    }

    protected Collection<IProject> collectReachableProjects(IModelDescriptor model) {
        HashSet<IProject> reachableProjects = new HashSet<IProject>();
        reachableProjects.add(model.getRoot().getProject());
        for (IResource referencedModelRoot : model.getReferencedRoots()) {
            if (referencedModelRoot instanceof IFile) {
                IModelDescriptor referencedModel = ModelDescriptorRegistry.INSTANCE.getModel((IFile)referencedModelRoot);
                reachableProjects.addAll(this.collectReachableProjects(referencedModel));
                continue;
            }
            if (!(referencedModelRoot instanceof IContainer)) continue;
            for (IModelDescriptor referencedModel : ModelDescriptorRegistry.INSTANCE.getModels((IContainer)referencedModelRoot)) {
                reachableProjects.addAll(this.collectReachableProjects(referencedModel));
            }
        }
        return reachableProjects;
    }

    protected Collection<IModelDescriptor> getModelsInScope() {
        HashSet<IModelDescriptor> modelsInScope = new HashSet<IModelDescriptor>();
        if (this.contextModel != null) {
            modelsInScope.add(this.contextModel);
        } else if (this.contextProject != null) {
            modelsInScope.addAll(ModelDescriptorRegistry.INSTANCE.getModels((IContainer)this.contextProject));
        }
        return modelsInScope;
    }

    protected ClassLoader getWorkspaceClassLoader() {
        if (this.workspaceClassLoader == null) {
            this.workspaceClassLoader = this.createWorkspaceClassLoader();
        }
        return this.workspaceClassLoader;
    }

    protected ClassLoader createWorkspaceClassLoader() {
        HashSet<URL> outputURLs = new HashSet<URL>();
        for (IProject project : this.getProjectsInScope()) {
            try {
                IPath outputPath = this.getJavaOutputPath(project);
                if (outputPath == null) continue;
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFolder javaOutputFolder = workspaceRoot.getFolder(outputPath);
                URL outputURL = javaOutputFolder.getLocation().toFile().toURI().toURL();
                outputURLs.add(outputURL);
            }
            catch (Exception exception) {}
        }
        return !outputURLs.isEmpty() ? new URLClassLoader(outputURLs.toArray(new URL[outputURLs.size()]), this.searchArchives ? Thread.currentThread().getContextClassLoader() : null) : null;
    }

    protected IPath getJavaOutputPath(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected Class<?> tryLoadClass(String clazzName) throws ClassNotFoundException {
        return this.getWorkspaceClassLoader().loadClass(clazzName);
    }

    public URL getResource(String path) {
        URL url = this.resolveAgainstProjectsInScope(path);
        if (url != null) {
            return url;
        }
        if (path.endsWith("xpt") && (url = this.resolveAgainstSpecialFoldersInScope(this.getTemplateFolderName(), path)) != null) {
            return url;
        }
        if (path.endsWith("ext") && (url = this.resolveAgainstSpecialFoldersInScope(this.getExtensionFolderName(), path)) != null) {
            return url;
        }
        if (path.endsWith("chk") && (url = this.resolveAgainstSpecialFoldersInScope(this.getCheckFolderName(), path)) != null) {
            return url;
        }
        url = this.resolveAgainstWorkspaceClasspath(path);
        if (url != null) {
            return url;
        }
        url = this.resolveAgainstModelFilesInScope(path);
        if (url != null) {
            return url;
        }
        if (this.searchArchives) {
            return super.getResource(path);
        }
        return null;
    }

    protected URL resolveAgainstProjectsInScope(String path) {
        for (IProject project : this.getProjectsInScope()) {
            IFile file = project.getFile((IPath)new Path(path));
            if (file == null || !file.exists()) continue;
            try {
                return file.getLocation().toFile().toURI().toURL();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected URL resolveAgainstSpecialFoldersInScope(String specialFolderName, String path) {
        for (IProject project : this.getProjectsInScope()) {
            IFolder specialFolder;
            IFile templateFile;
            if (specialFolderName == null || specialFolderName.length() <= 0 || (templateFile = (specialFolder = project.getFolder(specialFolderName)).getFile((IPath)new Path(path))) == null || !templateFile.exists()) continue;
            try {
                return templateFile.getLocation().toFile().toURI().toURL();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected String getTemplateFolderName() {
        return DEFAULT_TEMPLATE_FOLDER_NAME;
    }

    protected String getExtensionFolderName() {
        return DEFAULT_EXTENSION_FOLDER_NAME;
    }

    protected String getCheckFolderName() {
        return DEFAULT_CHECK_FOLDER_NAME;
    }

    protected URL resolveAgainstWorkspaceClasspath(String path) {
        try {
            ClassLoader classLoader = this.getWorkspaceClassLoader();
            if (classLoader != null) {
                return classLoader.getResource(path);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected URL resolveAgainstModelFilesInScope(String path) {
        HashSet<IContainer> modelFileContainers = new HashSet<IContainer>();
        for (IModelDescriptor model : this.getModelsInScope()) {
            for (IFile modelFile : model.getPersistedFiles(true)) {
                modelFileContainers.add(modelFile.getParent());
            }
        }
        for (IContainer container : modelFileContainers) {
            IFile file = container.getFile((IPath)new Path(path));
            if (file == null || !file.exists()) continue;
            try {
                return file.getLocation().toFile().toURI().toURL();
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

