/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.sphinx.emf.editors.IModelEditorInputChangeAnalyzer;
import org.eclipse.sphinx.emf.editors.IModelEditorInputChangeHandler;
import org.eclipse.ui.IEditorInput;

public class ModelEditorInputSynchronizer
implements IDisposable {
    private ResourceSetListener resourceLoadedListener;
    private ResourceSetListener resourceMovedListener;
    private ResourceSetListener resourceRemovedListener;
    private ResourceSetListener objectChangedListener;
    protected IEditorInput editorInput;
    protected TransactionalEditingDomain editingDomain;
    protected IModelEditorInputChangeAnalyzer editorInputChangeAnalyzer;
    protected IModelEditorInputChangeHandler editorInputChangeHandler;

    public ModelEditorInputSynchronizer(IEditorInput editorInput, TransactionalEditingDomain editingDomain, IModelEditorInputChangeAnalyzer editorInputChangeAnalyzer, IModelEditorInputChangeHandler editorInputChangeHandler) {
        Assert.isNotNull((Object)editorInput);
        Assert.isNotNull((Object)editingDomain);
        Assert.isNotNull((Object)editorInputChangeAnalyzer);
        Assert.isNotNull((Object)editorInputChangeHandler);
        this.editorInput = editorInput;
        this.editingDomain = editingDomain;
        this.editorInputChangeAnalyzer = editorInputChangeAnalyzer;
        this.editorInputChangeHandler = editorInputChangeHandler;
        this.installModelChangeListeners();
    }

    protected void installModelChangeListeners() {
        this.resourceLoadedListener = this.createResourceLoadedListener();
        Assert.isNotNull((Object)this.resourceLoadedListener);
        this.editingDomain.addResourceSetListener(this.resourceLoadedListener);
        this.resourceMovedListener = this.createResourceMovedListener();
        Assert.isNotNull((Object)this.resourceMovedListener);
        this.editingDomain.addResourceSetListener(this.resourceMovedListener);
        this.resourceRemovedListener = this.createResourceRemovedListener();
        Assert.isNotNull((Object)this.resourceRemovedListener);
        this.editingDomain.addResourceSetListener(this.resourceRemovedListener);
        this.objectChangedListener = this.createObjectChangedListener();
        Assert.isNotNull((Object)this.objectChangedListener);
        this.editingDomain.addResourceSetListener(this.objectChangedListener);
    }

    protected void uninstallModelChangeListeners() {
        this.editingDomain.removeResourceSetListener(this.resourceLoadedListener);
        this.editingDomain.removeResourceSetListener(this.resourceMovedListener);
        this.editingDomain.removeResourceSetListener(this.resourceRemovedListener);
        this.editingDomain.removeResourceSetListener(this.objectChangedListener);
    }

    protected ResourceSetListener createResourceLoadedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    Resource loadedResource;
                    Notification notification;
                    if (!(object instanceof Notification) || !(notification = (Notification)object).getNewBooleanValue() || !ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containsEditorInputResourceURI(ModelEditorInputSynchronizer.this.editorInput, Collections.singleton((loadedResource = (Resource)notification.getNotifier()).getURI()))) continue;
                    if (loadedResource.isLoaded()) {
                        ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputResourceLoaded(ModelEditorInputSynchronizer.this.editorInput);
                        break;
                    }
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputResourceUnloaded(ModelEditorInputSynchronizer.this.editorInput);
                    break;
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceMovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)1)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    URI oldResourceURI;
                    Notification notification;
                    if (!(object instanceof Notification) || !((notification = (Notification)object).getOldValue() instanceof URI) || (oldResourceURI = (URI)notification.getOldValue()) == null || !ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containsEditorInputResourceURI(ModelEditorInputSynchronizer.this.editorInput, Collections.singleton(oldResourceURI))) continue;
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputResourceMoved(ModelEditorInputSynchronizer.this.editorInput, oldResourceURI, (URI)notification.getNewValue());
                    break;
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createResourceRemovedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)4).or(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResourceSet(), (int)0))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<Resource> removedResources = new HashSet<Resource>();
                HashSet<Resource> addedResources = new HashSet<Resource>();
                List notifications = event.getNotifications();
                for (Object object : notifications) {
                    Notification notification;
                    Object notifier;
                    if (!(object instanceof Notification) || !((notifier = (notification = (Notification)object).getNotifier()) instanceof ResourceSet)) continue;
                    if (notification.getEventType() == 3 || notification.getEventType() == 5) {
                        ArrayList<Resource> newResources = new ArrayList<Resource>();
                        Object newValue = notification.getNewValue();
                        if (newValue instanceof List) {
                            List newResourcesValue = (List)newValue;
                            newResources.addAll(newResourcesValue);
                        } else if (newValue instanceof Resource) {
                            newResources.add((Resource)newValue);
                        }
                        for (Resource newResource : newResources) {
                            Resource removedResource = this.findEquivalentResource(removedResources, newResource);
                            if (removedResource != null) {
                                removedResources.remove(removedResource);
                                continue;
                            }
                            addedResources.add(newResource);
                        }
                        continue;
                    }
                    if (notification.getEventType() != 4 && notification.getEventType() != 6) continue;
                    ArrayList<Resource> oldResources = new ArrayList<Resource>();
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof List) {
                        List oldResourcesValue = (List)oldValue;
                        oldResources.addAll(oldResourcesValue);
                    } else if (oldValue instanceof Resource) {
                        oldResources.add((Resource)oldValue);
                    }
                    for (Resource oldResource : oldResources) {
                        Resource oldAddedResource = this.findEquivalentResource(addedResources, oldResource);
                        if (oldAddedResource != null) {
                            addedResources.remove(oldAddedResource);
                            continue;
                        }
                        removedResources.add(oldResource);
                    }
                }
                HashSet<URI> removedResourceURIs = new HashSet<URI>(removedResources.size());
                for (Resource removedResource : removedResources) {
                    removedResourceURIs.add(removedResource.getURI());
                }
                if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containsEditorInputResourceURI(ModelEditorInputSynchronizer.this.editorInput, removedResourceURIs)) {
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputResourceRemoved(ModelEditorInputSynchronizer.this.editorInput);
                }
            }

            protected Resource findEquivalentResource(Set<Resource> resources, Resource resource) {
                URI uri = resource.getURI();
                for (Resource equivalentResourceCandidate : resources) {
                    if (!equivalentResourceCandidate.getURI().equals(uri)) continue;
                    return equivalentResourceCandidate;
                }
                return null;
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected ResourceSetListener createObjectChangedListener() {
        return new ResourceSetListenerImpl(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.eINSTANCE.getEResource(), (int)2).or(NotificationFilter.createNotifierTypeFilter(EObject.class))){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                HashSet<EObject> addedObjects = new HashSet<EObject>();
                HashSet<EObject> removedObjects = new HashSet<EObject>();
                HashSet<EObject> movedObjects = new HashSet<EObject>();
                HashSet<EObject> changedObjects = new HashSet<EObject>();
                for (Notification notification : event.getNotifications()) {
                    if (notification.getEventType() == 1 || notification.getEventType() == 3 || notification.getEventType() == 5) {
                        ArrayList<EObject> newValues = new ArrayList<EObject>();
                        Object newValue = notification.getNewValue();
                        if (newValue instanceof List) {
                            List newValueList = (List)newValue;
                            newValues.addAll(newValueList);
                        } else if (newValue instanceof EObject) {
                            newValues.add((EObject)newValue);
                        }
                        for (EObject value : newValues) {
                            changedObjects.add(value);
                            if (removedObjects.contains(value)) {
                                movedObjects.add(value);
                                removedObjects.remove(value);
                                continue;
                            }
                            addedObjects.add(value);
                        }
                        continue;
                    }
                    if (notification.getEventType() != 2 && notification.getEventType() != 4 && notification.getEventType() != 6) continue;
                    ArrayList<EObject> oldValues = new ArrayList<EObject>();
                    Object oldValue = notification.getOldValue();
                    if (oldValue instanceof List) {
                        List oldValueList = (List)oldValue;
                        oldValues.addAll(oldValueList);
                    } else if (oldValue instanceof EObject) {
                        oldValues.add((EObject)oldValue);
                    }
                    for (EObject value : oldValues) {
                        changedObjects.add(value);
                        if (addedObjects.contains(value)) {
                            movedObjects.add(value);
                            addedObjects.remove(value);
                            continue;
                        }
                        removedObjects.add(value);
                    }
                }
                if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containsEditorInputObject(ModelEditorInputSynchronizer.this.editorInput, addedObjects)) {
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputObjectAdded(ModelEditorInputSynchronizer.this.editorInput, addedObjects);
                }
                if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containsEditorInputObject(ModelEditorInputSynchronizer.this.editorInput, removedObjects)) {
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputObjectRemoved(ModelEditorInputSynchronizer.this.editorInput, removedObjects);
                }
                if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containsEditorInputObject(ModelEditorInputSynchronizer.this.editorInput, movedObjects)) {
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputObjectMoved(ModelEditorInputSynchronizer.this.editorInput, movedObjects);
                }
                if (ModelEditorInputSynchronizer.this.editorInputChangeAnalyzer.containsEditorInputObject(ModelEditorInputSynchronizer.this.editorInput, changedObjects)) {
                    ModelEditorInputSynchronizer.this.editorInputChangeHandler.handleEditorInputObjectChanged(ModelEditorInputSynchronizer.this.editorInput, changedObjects);
                }
            }

            public boolean isPostcommitOnly() {
                return true;
            }
        };
    }

    protected IOperationHistory getOperationHistory() {
        CommandStack commandStack = this.editingDomain.getCommandStack();
        if (commandStack instanceof IWorkspaceCommandStack) {
            return ((IWorkspaceCommandStack)commandStack).getOperationHistory();
        }
        return OperationHistoryFactory.getOperationHistory();
    }

    public void dispose() {
        this.uninstallModelChangeListeners();
    }
}

