/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.sphinx.emf.search.ui.MatchEvent;
import org.eclipse.sphinx.emf.search.ui.ModelSearchMatch;
import org.eclipse.sphinx.emf.search.ui.ModelSearchResult;
import org.eclipse.sphinx.emf.search.ui.actions.CollapseAllAction;
import org.eclipse.sphinx.emf.search.ui.actions.ExpandAllAction;
import org.eclipse.sphinx.emf.search.ui.actions.RemoveAllMatchesAction;
import org.eclipse.sphinx.emf.search.ui.actions.RemoveMatchAction;
import org.eclipse.sphinx.emf.search.ui.actions.RemoveSelectedMatchesAction;
import org.eclipse.sphinx.emf.search.ui.actions.SelectAllAction;
import org.eclipse.sphinx.emf.search.ui.actions.SetLayoutAction;
import org.eclipse.sphinx.emf.search.ui.actions.ShowNextResultAction;
import org.eclipse.sphinx.emf.search.ui.actions.ShowPreviousResultAction;
import org.eclipse.sphinx.emf.search.ui.internal.Activator;
import org.eclipse.sphinx.emf.search.ui.internal.INavigate;
import org.eclipse.sphinx.emf.search.ui.internal.TableViewerNavigator;
import org.eclipse.sphinx.emf.search.ui.internal.TreeViewerNavigator;
import org.eclipse.sphinx.emf.search.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.search.ui.providers.AbstractModelSearchContentProvider;
import org.eclipse.sphinx.emf.search.ui.providers.ModelSearchLabelProvider;
import org.eclipse.sphinx.emf.search.ui.providers.ModelSearchTreeContentProvider;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ModelSearchResultViewPage
extends Page
implements ISearchResultPage,
ITabbedPropertySheetPageContributor,
IAdaptable {
    protected static final ModelSearchMatch[] EMPTY_MATCH_ARRAY = new ModelSearchMatch[0];
    protected Set<IPropertySheetPage> propertySheetPages = new HashSet<IPropertySheetPage>();
    private String pageId;
    private boolean isBusyShown;
    private boolean batchedClearAll;
    private int currentLayout;
    private final int supportedLayouts;
    private int currentMatchIndex = 0;
    private Integer elementLimit;
    private Composite viewerContainer;
    private Control busyLabel;
    private MenuManager menu;
    private StructuredViewer viewer;
    private PageBook pagebook;
    private ModelSearchResult input;
    private ISearchResultViewPart viewPart;
    private IQueryListener searchQueryListener;
    private SelectionProviderAdapter viewerAdapter;
    private ISearchResultListener searchResultListener;
    private AbstractModelSearchContentProvider contentProvider;
    private ModelSearchLabelProvider labelProvider;
    private Set<Object> batchedUpdates;
    private RemoveAllMatchesAction removeAllMatchesAction;
    private RemoveSelectedMatchesAction removeSelectedMatches;
    private RemoveMatchAction removeCurrentMatch;
    private ShowNextResultAction showNextAction;
    private ShowPreviousResultAction showPreviousAction;
    private ExpandAllAction expandAllAction;
    private CollapseAllAction collapseAllAction;
    private SelectAllAction selectAllAction;
    private SetLayoutAction flatAction;
    private SetLayoutAction hierarchicalAction;
    private volatile boolean isUIUpdateScheduled = false;
    private volatile boolean scheduleEnsureSelection = false;
    private static final String KEY_LAYOUT = "org.eclipse.sphinx.emf.search.ui.resultpage.layout";
    public static final int FLAG_LAYOUT_FLAT = 1;
    public static final int FLAG_LAYOUT_TREE = 2;

    public ModelSearchResultViewPage(int supportedLayouts) {
        this.supportedLayouts = supportedLayouts;
        this.initLayout();
        this.removeAllMatchesAction = new RemoveAllMatchesAction(this);
        this.removeSelectedMatches = new RemoveSelectedMatchesAction(this);
        this.removeCurrentMatch = new RemoveMatchAction(this);
        this.showNextAction = new ShowNextResultAction(this);
        this.showPreviousAction = new ShowPreviousResultAction(this);
        if ((supportedLayouts & 2) != 0) {
            this.expandAllAction = new ExpandAllAction();
            this.collapseAllAction = new CollapseAllAction();
        }
        this.selectAllAction = new SelectAllAction();
        this.createLayoutActions();
        this.batchedUpdates = new HashSet<Object>();
        this.batchedClearAll = false;
        this.searchResultListener = new ISearchResultListener(){

            public void searchResultChanged(SearchResultEvent e) {
                ModelSearchResultViewPage.this.handleSearchResultChanged(e);
            }
        };
        this.elementLimit = null;
    }

    public ModelSearchResultViewPage() {
        this(3);
    }

    public Object getUIState() {
        return this.viewer.getSelection();
    }

    public void setInput(ISearchResult newSearch, Object uiState) {
        if (newSearch != null && !(newSearch instanceof ModelSearchResult)) {
            return;
        }
        ModelSearchResult oldSearch = this.input;
        if (oldSearch != null) {
            this.disconnectViewer();
            oldSearch.removeListener(this.searchResultListener);
        }
        this.input = (ModelSearchResult)newSearch;
        if (this.input != null) {
            this.input.addListener(this.searchResultListener);
            this.connectViewer(this.input);
            if (uiState instanceof ISelection) {
                this.viewer.setSelection((ISelection)uiState, true);
            } else {
                this.navigateNext(true);
            }
            this.updateBusyLabel();
            this.turnOffDecoration();
            this.scheduleUIUpdate();
        } else {
            this.getViewPart().updateLabel();
        }
    }

    private void updateBusyLabel() {
        boolean shouldShowBusy;
        ModelSearchResult result = this.getInput();
        boolean bl = shouldShowBusy = result != null && NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery()) && result.getMatchCount() == 0;
        if (shouldShowBusy == this.isBusyShown) {
            return;
        }
        this.isBusyShown = shouldShowBusy;
        this.showBusyLabel(this.isBusyShown);
    }

    private void initLayout() {
        this.currentLayout = this.supportsTreeLayout() ? 2 : 1;
    }

    private void createLayoutActions() {
        if (this.countBits(this.supportedLayouts) > 1) {
            this.flatAction = new SetLayoutAction(this, Messages.ModelSearchResultViewPage_flat_layout_label, Messages.ModelSearchResultViewPage_flat_layout_tooltip, 1);
            this.hierarchicalAction = new SetLayoutAction(this, Messages.ModelSearchResultViewPage_hierarchical_layout_label, Messages.ModelSearchResultViewPage_hierarchical_layout_tooltip, 2);
            SearchPluginImages.setImageDescriptors((IAction)this.flatAction, (String)"lcl16/", (String)"org.eclipse.search.ui.flatLayout.gif");
            SearchPluginImages.setImageDescriptors((IAction)this.hierarchicalAction, (String)"lcl16/", (String)"org.eclipse.search.ui.hierarchicalLayout.gif");
        }
    }

    private int countBits(int layoutFlags) {
        int bitCount = 0;
        int i = 0;
        while (i < 32) {
            if (layoutFlags % 2 == 1) {
                ++bitCount;
            }
            layoutFlags >>= 1;
            ++i;
        }
        return bitCount;
    }

    private boolean supportsTreeLayout() {
        return this.isLayoutSupported(2);
    }

    public boolean isLayoutSupported(int layout) {
        return (layout & this.supportedLayouts) == layout;
    }

    private void showBusyLabel(boolean shouldShowBusy) {
        if (shouldShowBusy) {
            this.pagebook.showPage(this.busyLabel);
        } else {
            this.pagebook.showPage((Control)this.viewerContainer);
        }
    }

    private void connectViewer(ModelSearchResult search) {
        this.viewer.setInput((Object)search);
    }

    private void disconnectViewer() {
        this.viewer.setInput(null);
    }

    public void gotoNextMatch() {
        this.gotoNextMatch(false);
    }

    private void gotoNextMatch(boolean activateEditor) {
        ++this.currentMatchIndex;
        ModelSearchMatch nextMatch = this.getCurrentMatch();
        if (nextMatch == null) {
            this.navigateNext(true);
            this.currentMatchIndex = 0;
        }
        this.showCurrentMatch(activateEditor);
    }

    public void gotoPreviousMatch() {
        this.gotoPreviousMatch(false);
    }

    private void gotoPreviousMatch(boolean activateEditor) {
        --this.currentMatchIndex;
        ModelSearchMatch nextMatch = this.getCurrentMatch();
        if (nextMatch == null) {
            this.navigateNext(false);
            this.currentMatchIndex = this.getDisplayedMatchCount(this.getFirstSelectedElement()) - 1;
        }
        this.showCurrentMatch(activateEditor);
    }

    private void navigateNext(boolean forward) {
        INavigate navigator = null;
        navigator = this.viewer instanceof TableViewer ? new TableViewerNavigator((TableViewer)this.viewer) : new TreeViewerNavigator(this, (TreeViewer)this.viewer);
        navigator.navigateNext(forward);
    }

    public ModelSearchResult getInput() {
        return this.input;
    }

    public int getDisplayedMatchCount(Object element) {
        ModelSearchResult result = this.getInput();
        if (result == null) {
            return 0;
        }
        ModelSearchMatch[] matches = result.getMatches(element);
        return matches.length;
    }

    protected ISearchResultViewPart getViewPart() {
        return this.viewPart;
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.viewPart = part;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.pageId = id;
    }

    public String getID() {
        return this.pageId;
    }

    public String getLabel() {
        ModelSearchResult result = this.getInput();
        if (result == null) {
            return "";
        }
        return result.getLabel();
    }

    protected IDialogSettings getSettings() {
        IDialogSettings parent = Activator.getDefault().getDialogSettings();
        IDialogSettings settings = parent.getSection(this.getID());
        if (settings == null) {
            settings = parent.addNewSection(this.getID());
        }
        return settings;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void internalRemoveSelected() {
        ModelSearchResult result = this.getInput();
        if (result == null) {
            return;
        }
        StructuredViewer viewer = this.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        HashSet<ModelSearchMatch> set = new HashSet<ModelSearchMatch>();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider cp = (ITreeContentProvider)viewer.getContentProvider();
            this.collectAllMatchesBelow(result, set, cp, selection.toArray());
        } else {
            this.collectAllMatches(set, selection.toArray());
        }
        this.navigateNext(true);
        ModelSearchMatch[] matches = new ModelSearchMatch[set.size()];
        set.toArray(matches);
        result.removeMatches(matches);
    }

    private void collectAllMatches(Set<ModelSearchMatch> set, Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ModelSearchMatch[] matches;
            Object element = objectArray[n2];
            ModelSearchMatch[] modelSearchMatchArray = matches = this.getDisplayedMatches(element);
            int n3 = matches.length;
            int n4 = 0;
            while (n4 < n3) {
                ModelSearchMatch matche = modelSearchMatchArray[n4];
                set.add(matche);
                ++n4;
            }
            ++n2;
        }
    }

    private void collectAllMatchesBelow(ModelSearchResult result, Set<ModelSearchMatch> set, ITreeContentProvider cp, Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ModelSearchMatch[] matches;
            Object element = objectArray[n2];
            ModelSearchMatch[] modelSearchMatchArray = matches = this.getDisplayedMatches(element);
            int n3 = matches.length;
            int n4 = 0;
            while (n4 < n3) {
                ModelSearchMatch matche = modelSearchMatchArray[n4];
                set.add(matche);
                ++n4;
            }
            Object[] children = cp.getChildren(element);
            this.collectAllMatchesBelow(result, set, cp, children);
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        this.searchQueryListener = this.createQueryListener();
        this.menu = new MenuManager("#PopUp");
        this.menu.setRemoveAllWhenShown(true);
        this.menu.setParent((IContributionManager)this.getSite().getActionBars().getMenuManager());
        this.menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SearchView.createContextMenuGroups((IMenuManager)mgr);
                ModelSearchResultViewPage.this.fillContextMenu(mgr);
                ModelSearchResultViewPage.this.viewPart.fillContextMenu(mgr);
            }
        });
        this.pagebook = new PageBook(parent, 0);
        this.pagebook.setLayoutData((Object)new GridData(1808));
        this.busyLabel = this.createBusyControl();
        this.viewerContainer = new Composite((Composite)this.pagebook, 0);
        this.viewerContainer.setLayoutData((Object)new GridData(1808));
        this.viewerContainer.setSize(100, 100);
        this.viewerContainer.setLayout((Layout)new FillLayout());
        this.viewerAdapter = new SelectionProviderAdapter();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewerAdapter);
        this.getSite().registerContextMenu(this.viewPart.getViewSite().getId(), this.menu, (ISelectionProvider)this.viewerAdapter);
        this.createViewer(this.viewerContainer, this.currentLayout);
        this.showBusyLabel(this.isBusyShown);
        NewSearchUI.addQueryListener((IQueryListener)this.searchQueryListener);
    }

    private void createViewer(Composite parent, int layout) {
        TableViewer viewer;
        if ((layout & 1) != 0) {
            viewer = this.createTableViewer(parent);
            this.viewer = viewer;
            this.configureTableViewer(viewer);
        } else if ((layout & 2) != 0) {
            viewer = this.createTreeViewer(parent);
            this.viewer = viewer;
            this.configureTreeViewer((TreeViewer)viewer);
            this.collapseAllAction.setViewer((TreeViewer)viewer);
            this.expandAllAction.setViewer((TreeViewer)viewer);
        }
        this.selectAllAction.setViewer(this.viewer);
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        SearchView.createToolBarGroups((IToolBarManager)tbm);
        this.fillToolbar(tbm);
        tbm.update(false);
        new OpenAndLinkWithEditorHelper(this.viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    ModelSearchResultViewPage.this.handleOpen(new OpenEvent((Viewer)ModelSearchResultViewPage.this.viewer, selection));
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                ModelSearchResultViewPage.this.handleOpen(new OpenEvent((Viewer)ModelSearchResultViewPage.this.viewer, selection));
            }
        };
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelSearchResultViewPage.this.currentMatchIndex = -1;
                ModelSearchResultViewPage.this.removeSelectedMatches.setEnabled(ModelSearchResultViewPage.this.canRemoveMatchesWith(event.getSelection()));
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.viewerAdapter);
        Menu menu = this.menu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.updateLayoutActions();
        this.getViewPart().updateLabel();
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        this.contentProvider = new ModelSearchTreeContentProvider(this);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ModelSearchLabelProvider();
        treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    protected void configureTableViewer(TableViewer tableViewer) {
        this.contentProvider = new ModelSearchTreeContentProvider(this);
        tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ModelSearchLabelProvider();
        tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    protected void handleOpen(OpenEvent event) {
        Viewer viewer = event.getViewer();
        boolean hasCurrentMatch = this.showCurrentMatch(OpenStrategy.activateOnOpen());
        ISelection sel = event.getSelection();
        if (viewer instanceof TreeViewer && sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            TreeViewer tv = (TreeViewer)this.getViewer();
            Object element = selection.getFirstElement();
            if (element != null) {
                if (!hasCurrentMatch && this.getDisplayedMatchCount(element) > 0) {
                    this.gotoNextMatch(OpenStrategy.activateOnOpen());
                } else {
                    tv.setExpandedState(element, !tv.getExpandedState(element));
                }
            }
            return;
        }
        if (!hasCurrentMatch) {
            this.gotoNextMatch(OpenStrategy.activateOnOpen());
        }
    }

    protected void fillToolbar(IToolBarManager tbm) {
        tbm.appendToGroup("group.show", (IAction)this.showNextAction);
        tbm.appendToGroup("group.show", (IAction)this.showPreviousAction);
        tbm.appendToGroup("group.removeMatches", (IAction)this.removeSelectedMatches);
        tbm.appendToGroup("group.removeMatches", (IAction)this.removeAllMatchesAction);
        IActionBars actionBars = this.getSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.showNextAction);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.showPreviousAction);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeSelectedMatches);
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        }
        if (this.getLayout() == 2) {
            tbm.appendToGroup("group.viewerSetup", (IAction)this.expandAllAction);
            tbm.appendToGroup("group.viewerSetup", (IAction)this.collapseAllAction);
        }
    }

    public void setLayout(int layout) {
        Assert.isTrue((this.countBits(layout) == 1 ? 1 : 0) != 0);
        Assert.isTrue((boolean)this.isLayoutSupported(layout));
        if (this.countBits(this.supportedLayouts) < 2) {
            return;
        }
        if (this.currentLayout == layout) {
            return;
        }
        this.currentLayout = layout;
        ISelection selection = this.viewer.getSelection();
        this.disconnectViewer();
        this.disposeViewer();
        this.createViewer(this.viewerContainer, layout);
        this.viewerContainer.layout(true);
        this.connectViewer(this.input);
        this.viewer.setSelection(selection, true);
        this.getSettings().put(KEY_LAYOUT, layout);
        this.getViewPart().updateLabel();
    }

    private void disposeViewer() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this.viewerAdapter);
        this.viewer.getControl().dispose();
        this.viewer = null;
    }

    private void updateLayoutActions() {
        if (this.flatAction != null) {
            this.flatAction.setChecked(this.currentLayout == this.flatAction.getLayout());
        }
        if (this.hierarchicalAction != null) {
            this.hierarchicalAction.setChecked(this.currentLayout == this.hierarchicalAction.getLayout());
        }
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 770);
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new TableViewer(parent, 770);
    }

    private Control createBusyControl() {
        Table busyLabel = new Table((Composite)this.pagebook, 0);
        TableItem item = new TableItem(busyLabel, 0);
        item.setText(Messages.ModelSearchResultViewPage_searching_label);
        busyLabel.setLayoutData((Object)new GridData(768));
        return busyLabel;
    }

    private IQueryListener createQueryListener() {
        return new IQueryListener(){

            public void queryAdded(ISearchQuery query) {
            }

            public void queryRemoved(ISearchQuery query) {
            }

            public void queryStarting(final ISearchQuery query) {
                Runnable runnable1 = new Runnable(){

                    @Override
                    public void run() {
                        ModelSearchResultViewPage.this.updateBusyLabel();
                        ModelSearchResult result = ModelSearchResultViewPage.this.getInput();
                        if (result == null || !result.getQuery().equals(query)) {
                            return;
                        }
                        ModelSearchResultViewPage.this.turnOffDecoration();
                        ModelSearchResultViewPage.this.scheduleUIUpdate();
                    }
                };
                ModelSearchResultViewPage.this.asyncExec(runnable1);
            }

            public void queryFinished(ISearchQuery query) {
                ModelSearchResultViewPage.this.postEnsureSelection();
            }
        };
    }

    protected void postEnsureSelection() {
        this.scheduleEnsureSelection = true;
        this.scheduleUIUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchedClear() {
        ModelSearchResultViewPage modelSearchResultViewPage = this;
        synchronized (modelSearchResultViewPage) {
            if (!this.batchedClearAll) {
                return;
            }
            this.batchedClearAll = false;
            this.updateBusyLabel();
        }
        this.getViewPart().updateLabel();
        this.clear();
    }

    private void asyncExec(final Runnable runnable) {
        final Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay == null || !currentDisplay.equals(control.getDisplay())) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            } else {
                runnable.run();
            }
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.appendToGroup("group.show", (IAction)this.showNextAction);
        mgr.appendToGroup("group.show", (IAction)this.showPreviousAction);
        if (this.getCurrentMatch() != null) {
            mgr.appendToGroup("group.removeMatches", (IAction)this.removeCurrentMatch);
        }
        if (this.canRemoveMatchesWith(this.getViewer().getSelection())) {
            mgr.appendToGroup("group.removeMatches", (IAction)this.removeSelectedMatches);
        }
        mgr.appendToGroup("group.removeMatches", (IAction)this.removeAllMatchesAction);
        if (this.getLayout() == 2) {
            mgr.appendToGroup("group.show", (IAction)this.expandAllAction);
        }
    }

    protected boolean canRemoveMatchesWith(ISelection selection) {
        return !selection.isEmpty();
    }

    private void showMatch(final ModelSearchMatch match, final boolean activateEditor) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable exception) {
                if (exception instanceof PartInitException) {
                    PartInitException pie = (PartInitException)exception;
                    ErrorDialog.openError((Shell)ModelSearchResultViewPage.this.getSite().getShell(), (String)Messages.ModelSearchResultViewPage_show_match, (String)Messages.ModelSearchResultViewPage_error_no_editor, (IStatus)pie.getStatus());
                }
            }

            public void run() throws Exception {
                IFile matchFile = ModelSearchResultViewPage.this.getFile(match);
                if (activateEditor && match != null) {
                    IEditorInput input;
                    IFile file;
                    IEditorPart editor = ModelSearchResultViewPage.this.getSite().getPage().getActiveEditor();
                    if (editor != null && (file = ResourceUtil.getFile((IEditorInput)(input = editor.getEditorInput()))) != null && file.equals((Object)match) && OpenStrategy.activateOnOpen()) {
                        ModelSearchResultViewPage.this.getSite().getPage().activate((IWorkbenchPart)editor);
                    }
                    try {
                        editor = IDE.openEditor((IWorkbenchPage)ModelSearchResultViewPage.this.getSite().getPage(), (IFile)matchFile, (boolean)OpenStrategy.activateOnOpen());
                    }
                    catch (PartInitException ex) {
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)((Object)ex));
                    }
                    if (editor != null && editor instanceof IViewerProvider) {
                        Viewer editorViewer = ((IViewerProvider)editor).getViewer();
                        editorViewer.setSelection((ISelection)new StructuredSelection(match.getElement()), true);
                    }
                }
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    private IFile getFile(ModelSearchMatch modelSearchMatch) {
        return EcorePlatformUtil.getFile((Object)modelSearchMatch.getElement());
    }

    public int getLayout() {
        return this.currentLayout;
    }

    private boolean showCurrentMatch(boolean activateEditor) {
        ModelSearchMatch currentMatch = this.getCurrentMatch();
        if (currentMatch != null) {
            this.showMatch(currentMatch, activateEditor);
            return true;
        }
        return false;
    }

    public ModelSearchMatch getCurrentMatch() {
        Object element = this.getFirstSelectedElement();
        if (element != null) {
            ModelSearchMatch[] matches = this.getDisplayedMatches(element);
            if (this.currentMatchIndex >= 0 && this.currentMatchIndex < matches.length) {
                return matches[this.currentMatchIndex];
            }
        }
        return null;
    }

    public ModelSearchMatch[] getDisplayedMatches(Object element) {
        ModelSearchResult result = this.getInput();
        if (result == null) {
            return EMPTY_MATCH_ARRAY;
        }
        ModelSearchMatch[] matches = result.getMatches(element);
        return matches;
    }

    private Object getFirstSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() > 0) {
            return selection.getFirstElement();
        }
        return null;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public void setFocus() {
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    private synchronized void scheduleUIUpdate() {
        if (!this.isUIUpdateScheduled) {
            this.isUIUpdateScheduled = true;
            new UpdateUIJob().schedule();
        }
    }

    private void turnOffDecoration() {
        IBaseLabelProvider lp = this.viewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(null);
        }
    }

    private void turnOnDecoration() {
        IBaseLabelProvider lp = this.viewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        }
    }

    public void setElementLimit(Integer limit) {
        this.elementLimit = limit;
        if (this.viewer != null) {
            this.viewer.refresh();
        }
        if (this.viewPart != null) {
            this.viewPart.updateLabel();
        }
    }

    public Integer getElementLimit() {
        return this.elementLimit;
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            this.postUpdate(((MatchEvent)e).getMatches());
        } else if (e instanceof RemoveAllEvent) {
            this.postClear();
        }
    }

    protected void evaluateChangedElements(ModelSearchMatch[] matches, Set<Object> changedElements) {
        ModelSearchMatch[] modelSearchMatchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            ModelSearchMatch matche = modelSearchMatchArray[n2];
            changedElements.add(matche.getElement());
            ++n2;
        }
    }

    private synchronized void postUpdate(ModelSearchMatch[] matches) {
        this.evaluateChangedElements(matches, this.batchedUpdates);
        this.scheduleUIUpdate();
    }

    private synchronized void runBatchedUpdates() {
        this.elementsChanged(this.batchedUpdates.toArray());
        this.batchedUpdates.clear();
        this.updateBusyLabel();
    }

    protected void elementsChanged(Object[] updatedElements) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(updatedElements);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    private synchronized void postClear() {
        this.batchedClearAll = true;
        this.batchedUpdates.clear();
        this.scheduleUIUpdate();
    }

    private synchronized boolean hasMoreUpdates() {
        return this.batchedClearAll || this.batchedUpdates.size() > 0;
    }

    private boolean isQueryRunning() {
        ModelSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery());
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class == adapter) {
            return this.getPropertySheetPage();
        }
        return null;
    }

    public IPropertySheetPage getPropertySheetPage() {
        TabbedPropertySheetPage propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        this.propertySheetPages.add((IPropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public String getContributorId() {
        return this.viewPart.getViewSite().getId();
    }

    private class SelectionProviderAdapter
    implements ISelectionProvider,
    ISelectionChangedListener {
        private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>(5);

        private SelectionProviderAdapter() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public ISelection getSelection() {
            return ModelSearchResultViewPage.this.viewer.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            ModelSearchResultViewPage.this.viewer.setSelection(selection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionChangedEvent wrappedEvent = new SelectionChangedEvent((ISelectionProvider)this, event.getSelection());
            for (ISelectionChangedListener listener : this.listeners) {
                listener.selectionChanged(wrappedEvent);
            }
        }
    }

    private class UpdateUIJob
    extends UIJob {
        public UpdateUIJob() {
            super(Messages.ModelSearchResultViewPage_update_job_name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = ModelSearchResultViewPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return Status.OK_STATUS;
            }
            ModelSearchResultViewPage.this.runBatchedClear();
            ModelSearchResultViewPage.this.runBatchedUpdates();
            if (ModelSearchResultViewPage.this.hasMoreUpdates() || ModelSearchResultViewPage.this.isQueryRunning()) {
                this.schedule(500L);
            } else {
                ModelSearchResultViewPage.this.isUIUpdateScheduled = false;
                ModelSearchResultViewPage.this.turnOnDecoration();
                ModelSearchResultViewPage.this.updateBusyLabel();
                if (ModelSearchResultViewPage.this.scheduleEnsureSelection) {
                    ModelSearchResultViewPage.this.scheduleEnsureSelection = false;
                    ModelSearchResult result = ModelSearchResultViewPage.this.getInput();
                    if (result != null && ModelSearchResultViewPage.this.viewer.getSelection().isEmpty()) {
                        ModelSearchResultViewPage.this.navigateNext(true);
                    }
                }
            }
            ModelSearchResultViewPage.this.viewPart.updateLabel();
            ModelSearchResultViewPage.this.viewer.refresh();
            return Status.OK_STATUS;
        }
    }
}

