/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.jobs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class CreateNewModelFileJob
extends WorkspaceJob {
    protected IFile newFile;
    protected IMetaModelDescriptor metaModelDescriptor;
    protected EPackage rootObjectEPackage;
    protected EClassifier rootObjectEClassifier;

    public CreateNewModelFileJob(String jobName, IFile newFile, IMetaModelDescriptor metaModelDescriptor, EPackage rootObjectEPackage, EClassifier rootObjectEClassifier) {
        super(jobName);
        Assert.isNotNull((Object)newFile);
        Assert.isNotNull((Object)metaModelDescriptor);
        Assert.isLegal((metaModelDescriptor != MetaModelDescriptorRegistry.ANY_MM ? 1 : 0) != 0);
        Assert.isLegal((metaModelDescriptor != MetaModelDescriptorRegistry.NO_MM ? 1 : 0) != 0);
        Assert.isNotNull((Object)rootObjectEPackage);
        Assert.isNotNull((Object)rootObjectEClassifier);
        this.newFile = newFile;
        this.metaModelDescriptor = metaModelDescriptor;
        this.rootObjectEPackage = rootObjectEPackage;
        this.rootObjectEClassifier = rootObjectEClassifier;
        this.setPriority(40);
        this.setRule(ExtendedPlatform.createSaveNewSchedulingRule((IResource)newFile));
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            EObject rootObject = this.createInitialModel();
            progress.worked(20);
            this.saveInitialModel(rootObject, (IProgressMonitor)progress.newChild(80));
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    protected EObject createInitialModel() {
        return this.rootObjectEPackage.getEFactoryInstance().create((EClass)this.rootObjectEClassifier);
    }

    protected void saveInitialModel(EObject rootObject, IProgressMonitor monitor) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((IContainer)this.newFile.getProject(), (IMetaModelDescriptor)this.metaModelDescriptor);
        EcorePlatformUtil.saveNewModelResource((TransactionalEditingDomain)editingDomain, (IPath)this.newFile.getFullPath(), (String)this.metaModelDescriptor.getDefaultContentTypeId(), (EObject)rootObject, (boolean)false, (IProgressMonitor)monitor);
    }
}

