/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.edit.parts.ApplicationEditPart;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.edit.parts.ComponentEditPart;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.edit.parts.ComponentNameEditPart;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.edit.parts.ConnectionEditPart;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.edit.parts.ConnectionLabelEditPart;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.part.Hummingbird20VisualIDRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class Hummingbird20EditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            switch (Hummingbird20VisualIDRegistry.getVisualID(view)) {
                case 1000: {
                    return new ApplicationEditPart(view);
                }
                case 2001: {
                    return new ComponentEditPart(view);
                }
                case 5001: {
                    return new ComponentNameEditPart(view);
                }
                case 4001: {
                    return new ConnectionEditPart(view);
                }
                case 6001: {
                    return new ConnectionLabelEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)source.getFigure());
        }
        return new LabelCellEditorLocator((Label)source.getFigure());
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrappingLabel wrapLabel;

        public TextCellEditorLocator(WrappingLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrappingLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (!text.getFont().isDisposed()) {
                if (this.getWrapLabel().isTextWrapOn() && this.getWrapLabel().getText().length() > 0) {
                    rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
                } else {
                    int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                    rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
                }
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

