/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.ui.groups.FileSelectionGroup;
import org.eclipse.sphinx.platform.ui.wizards.pages.AbstractWizardPage;
import org.eclipse.sphinx.xtendxpand.CheckEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.ui.internal.Activator;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CheckConfigurationPage
extends AbstractWizardPage {
    protected FileSelectionGroup checkGroup;
    protected EObject modelObject;

    public CheckConfigurationPage(String pageName) {
        super(pageName);
    }

    public void init(EObject modelObject) {
        this.modelObject = modelObject;
    }

    protected Control doCreateControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        this.createPageContent(composite);
        return composite;
    }

    protected void createPageContent(Composite parent) {
        this.createCheckGroup(parent);
    }

    protected void createCheckGroup(Composite parent) {
        IFile modelFile = EcorePlatformUtil.getFile((EObject)this.modelObject);
        if (modelFile != null) {
            this.checkGroup = new FileSelectionGroup(Messages.label_checkModelBlock, Messages.label_useCheckModelButton, Messages.label_checkModelBlock, "chk", modelFile.getProject(), this.getDialogSettings());
            this.checkGroup.setSectionName(this.getCheckFileSelectionSectionName(this.modelObject));
            this.checkGroup.createContent(parent, 3);
        }
    }

    protected String getCheckFileSelectionSectionName(EObject object) {
        Assert.isNotNull((Object)object);
        return String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".SECTION" + EcoreResourceUtil.getURI((EObject)object).toString();
    }

    protected String doGetDescription() throws MissingResourceException {
        return Messages.desc_checkConfigurationPage;
    }

    protected String doGetTitle() throws MissingResourceException {
        return Messages.title_checkConfigurationPage;
    }

    protected boolean doIsPageComplete() {
        return true;
    }

    protected IStatus doValidateRules() {
        return null;
    }

    public Collection<CheckEvaluationRequest> getCheckEvaluationRequests() {
        Collection checkFiles;
        ArrayList<CheckEvaluationRequest> requests = new ArrayList<CheckEvaluationRequest>();
        if (this.modelObject != null && !(checkFiles = this.checkGroup.getFiles()).isEmpty()) {
            requests.add(new CheckEvaluationRequest(checkFiles, (Object)this.modelObject));
        }
        return requests;
    }

    public boolean isCheckEnabled() {
        return this.checkGroup.getEnableButtonState();
    }

    public void finish() {
        if (this.checkGroup != null) {
            this.checkGroup.saveGroupSettings();
        }
    }
}

