/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public abstract class AbstractFilteredObjectsSelectionDialog<T>
extends FilteredItemsSelectionDialog {
    private final String LAST_SELECTED_ITEM_KEY = "last.selected.item";
    protected List<T> items = new ArrayList<T>();

    public AbstractFilteredObjectsSelectionDialog(Shell shell, Collection<T> items) {
        this(shell, false, items);
    }

    public AbstractFilteredObjectsSelectionDialog(Shell shell, boolean multi, Collection<T> items) {
        super(shell, multi);
        this.items = new ArrayList<T>(items);
        this.setListLabelProvider(new BrowseItemListLabelProvider());
        this.setDetailsLabelProvider(new BrowseItemListLabelProvider());
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (T item : this.items) {
            contentProvider.add(item, itemsFilter);
        }
    }

    public String getElementName(Object item) {
        return this.toString(item);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean matchItem(Object item) {
                return this.matches(AbstractFilteredObjectsSelectionDialog.this.toString(item));
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected Comparator<?> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object item1, Object item2) {
                return AbstractFilteredObjectsSelectionDialog.this.safeStringCompareTo(AbstractFilteredObjectsSelectionDialog.this.toString(item1), AbstractFilteredObjectsSelectionDialog.this.toString(item2));
            }
        };
    }

    protected int safeStringCompareTo(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null || str2 == null) {
            return str1 == null ? -1 : 1;
        }
        return str1.compareTo(str2);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("last.selected.item");
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection("last.selected.item");
        }
        return settings;
    }

    protected abstract T toObject(String var1);

    protected abstract String toString(T var1);

    public class BrowseItemListLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return AbstractFilteredObjectsSelectionDialog.this.getElementName(element);
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

