/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sphinx.emf.mwe.resources.IWorkspaceResourceLoader;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.ui.wizards.AbstractWizard;
import org.eclipse.sphinx.xtendxpand.jobs.CheckJob;
import org.eclipse.sphinx.xtendxpand.jobs.M2TJob;
import org.eclipse.sphinx.xtendxpand.jobs.XpandJob;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;
import org.eclipse.sphinx.xtendxpand.preferences.PrDefaultExcludesPreference;
import org.eclipse.sphinx.xtendxpand.preferences.PrExcludesPreference;
import org.eclipse.sphinx.xtendxpand.ui.internal.Activator;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.ui.wizards.pages.CheckConfigurationPage;
import org.eclipse.sphinx.xtendxpand.ui.wizards.pages.XpandConfigurationPage;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.MetaModel;

public class M2TConfigurationWizard
extends AbstractWizard {
    protected EObject modelObject;
    protected TypeSystem typeSystem;
    private String m2tJobName;
    private IWorkspaceResourceLoader workspaceResourceLoader;
    private OutletsPreference outletsPreference;
    private ExtendedOutlet defaultOutlet;
    private IJobChangeListener resultMessageHandler;
    protected XpandConfigurationPage xpandConfigurationPage;
    protected CheckConfigurationPage checkConfigurationPage;

    public M2TConfigurationWizard(EObject modelObject, List<MetaModel> metaModels) {
        Assert.isNotNull(metaModels);
        this.setDialogSettings(Activator.getDefault().getDialogSettings());
        this.setWindowTitle(Messages.title_codeGen);
        this.modelObject = modelObject;
        this.typeSystem = new TypeSystemImpl();
        for (MetaModel metaModel : metaModels) {
            ((TypeSystemImpl)this.typeSystem).registerMetaModel(metaModel);
        }
    }

    public String getM2TJobName() {
        return this.m2tJobName != null ? this.m2tJobName : this.getDefaultM2TJobName();
    }

    protected String getDefaultM2TJobName() {
        return Messages.job_generatingCode;
    }

    public void setM2TJobName(String m2tJobName) {
        this.m2tJobName = m2tJobName;
    }

    public IWorkspaceResourceLoader getWorkspaceResourceLoader() {
        return this.workspaceResourceLoader;
    }

    public void setWorkspaceResourceLoader(IWorkspaceResourceLoader workspaceResourceLoader) {
        this.workspaceResourceLoader = workspaceResourceLoader;
    }

    public OutletsPreference getOutletsPreference() {
        return this.outletsPreference;
    }

    public void setOutletsPreference(OutletsPreference outletsPreference) {
        this.outletsPreference = outletsPreference;
    }

    public ExtendedOutlet getDefaultOutlet() {
        return this.defaultOutlet;
    }

    public void setDefaultOutlet(ExtendedOutlet defaultOutlet) {
        this.defaultOutlet = defaultOutlet;
    }

    public IJobChangeListener getResultMessageHandler() {
        return this.resultMessageHandler;
    }

    public void setResultMessageHandler(IJobChangeListener resultMessageHandler) {
        this.resultMessageHandler = resultMessageHandler;
    }

    public void addPages() {
        this.xpandConfigurationPage = this.createXpandConfigurationPage();
        this.addPage((IWizardPage)this.xpandConfigurationPage);
        this.checkConfigurationPage = this.createCheckConfigurationPage();
        this.addPage((IWizardPage)this.checkConfigurationPage);
    }

    protected XpandConfigurationPage createXpandConfigurationPage() {
        XpandConfigurationPage xpandPage = new XpandConfigurationPage(Messages.label_configPageName);
        xpandPage.init(this.modelObject, this.typeSystem, this.getOutletsPreference(), this.getDefaultOutlet());
        return xpandPage;
    }

    protected CheckConfigurationPage createCheckConfigurationPage() {
        CheckConfigurationPage checkPage = new CheckConfigurationPage(Messages.label_configPageName);
        checkPage.init(this.modelObject);
        return checkPage;
    }

    protected void doPerformFinish(IProgressMonitor monitor) throws CoreException {
        IJobChangeListener handler;
        ExtendedPlatformUI.showSystemConsole();
        CheckJob checkJob = this.isCheckRequired() ? this.createCheckJob() : null;
        XpandJob xpandJob = this.createXpandJob();
        M2TJob job = new M2TJob(this.getM2TJobName(), xpandJob, checkJob);
        job.setPriority(40);
        IFile file = EcorePlatformUtil.getFile((EObject)this.modelObject);
        if (file != null) {
            job.setRule((ISchedulingRule)file.getProject());
        }
        if ((handler = this.getResultMessageHandler()) != null) {
            job.addJobChangeListener(handler);
        }
        job.schedule();
    }

    protected boolean isCheckRequired() {
        return this.checkConfigurationPage.isCheckEnabled() && !this.checkConfigurationPage.getCheckEvaluationRequests().isEmpty();
    }

    protected XpandJob createXpandJob() {
        XpandJob job = new XpandJob(this.getM2TJobName(), this.typeSystem, this.xpandConfigurationPage.getXpandEvaluationRequests());
        job.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
        job.getOutlets().addAll(this.xpandConfigurationPage.getOutlets());
        job.setPriority(40);
        IFile file = EcorePlatformUtil.getFile((EObject)this.modelObject);
        if (file != null) {
            job.configureProtectedRegionResolver(this.getPrSrcPaths(this.xpandConfigurationPage.getOutlets()), ((Boolean)PrDefaultExcludesPreference.INSTANCE.get(file.getProject())).booleanValue(), (String)PrExcludesPreference.INSTANCE.get(file.getProject()));
            job.setRule((ISchedulingRule)file.getProject());
        }
        return job;
    }

    protected String getPrSrcPaths(Collection<? extends ExtendedOutlet> outlets) {
        HashSet<String> paths = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        ArrayList<? extends ExtendedOutlet> allOutlets = new ArrayList<ExtendedOutlet>(outlets);
        for (ExtendedOutlet extendedOutlet : allOutlets) {
            if (!extendedOutlet.isProtectedRegion()) continue;
            paths.add(extendedOutlet.getPath());
        }
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            builder.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    protected CheckJob createCheckJob() {
        CheckJob checkJob = new CheckJob(this.getM2TJobName(), this.typeSystem, this.checkConfigurationPage.getCheckEvaluationRequests());
        checkJob.setWorkspaceResourceLoader(this.getWorkspaceResourceLoader());
        checkJob.setPriority(40);
        IFile file = EcorePlatformUtil.getFile((EObject)this.modelObject);
        if (file != null) {
            checkJob.setRule((ISchedulingRule)file.getProject());
        }
        return checkJob;
    }

    protected void doPerformCancel(IProgressMonitor monitor) throws CoreException {
    }
}

