/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.report;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.compare.util.ModelCompareUtil;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class AbstractModelCompareReportGenerator
implements IPostProcessor {
    public static final String MODEL_DIFF_REPORT_KIND = "kind";
    public static final String MODEL_DIFF_REPORT_LEFT_DIFF_URI = "leftURI";
    public static final String MODEL_DIFF_REPORT_LEFT_DIFF_TEXT = "leftChangeText";
    public static final String MODEL_DIFF_REPORT_RIGHT_DIFF_URI = "rightURI";
    public static final String MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT = "rightChangeText";
    public static final String MODEL_DIFF_REPORT_TARGET_REPORT_FOLDER_NAME = "reports";

    protected abstract CharSequence doGenerate(Comparison var1);

    public void generate(Comparison comparison, IFile targetFile) {
        CharSequence _doGenerate = this.doGenerate(comparison);
        this.writeFile(targetFile, _doGenerate);
    }

    public Notifier getLeftObject(Comparison comparison) {
        boolean _notEquals;
        Object _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
        if (_notEquals) {
            boolean _not_1;
            boolean _not;
            EList _matchedResources = comparison.getMatchedResources();
            boolean _isEmpty = _matchedResources.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                EList _matchedResources_1 = comparison.getMatchedResources();
                MatchResource matchResource = (MatchResource)_matchedResources_1.get(0);
                return matchResource.getLeft();
            }
            EList _matches = comparison.getMatches();
            boolean _isEmpty_1 = _matches.isEmpty();
            boolean bl3 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                EList _matches_1 = comparison.getMatches();
                Match match = (Match)_matches_1.get(0);
                return match.getLeft();
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public Notifier getRightObject(Comparison comparison) {
        boolean _notEquals;
        Object _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
        if (_notEquals) {
            boolean _not_1;
            boolean _not;
            EList _matchedResources = comparison.getMatchedResources();
            boolean _isEmpty = _matchedResources.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                EList _matchedResources_1 = comparison.getMatchedResources();
                MatchResource matchResource = (MatchResource)_matchedResources_1.get(0);
                return matchResource.getRight();
            }
            EList _matches = comparison.getMatches();
            boolean _isEmpty_1 = _matches.isEmpty();
            boolean bl3 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                EList _matches_1 = comparison.getMatches();
                Match match = (Match)_matches_1.get(0);
                return match.getRight();
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public IProject getTargetProject(Comparison comparison) {
        block6: {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
            if (!_notEquals) break block6;
            EList _matchedResources = comparison.getMatchedResources();
            boolean _isEmpty = _matchedResources.isEmpty();
            if (_isEmpty) {
                EList _matches = comparison.getMatches();
                for (Match match : _matches) {
                    boolean _notEquals_1;
                    EObject _left = match.getLeft();
                    IFile file = EcorePlatformUtil.getFile((EObject)_left);
                    boolean _equals = Objects.equal((Object)file, null);
                    if (_equals) {
                        IFile _file;
                        EObject _right = match.getRight();
                        file = _file = EcorePlatformUtil.getFile((EObject)_right);
                    }
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)file, null);
                    if (!_notEquals_1) continue;
                    return file.getProject();
                }
            } else {
                EList _matchedResources_1 = comparison.getMatchedResources();
                for (MatchResource matchResource : _matchedResources_1) {
                    boolean _notEquals_1;
                    Resource _left = matchResource.getLeft();
                    IFile file = EcorePlatformUtil.getFile((Resource)_left);
                    boolean _equals = Objects.equal((Object)file, null);
                    if (_equals) {
                        IFile _file;
                        Resource _right = matchResource.getRight();
                        file = _file = EcorePlatformUtil.getFile((Resource)_right);
                    }
                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)file, null);
                    if (!_notEquals_1) continue;
                    return file.getProject();
                }
            }
        }
        return null;
    }

    public String getModelCompareInputText(Object object) {
        String label = "";
        if (object instanceof EObject) {
            String _string;
            URI uri = EcoreResourceUtil.getURI((EObject)((EObject)object), (boolean)true);
            URI _trimQuery = uri.trimQuery();
            label = _string = _trimQuery.toString();
        } else if (object instanceof Resource) {
            String _string_1;
            URI _uRI = ((Resource)object).getURI();
            URI _trimQuery_1 = _uRI.trimQuery();
            label = _string_1 = _trimQuery_1.toString();
        }
        return label;
    }

    public String getName(Object object) {
        String name = "";
        if (object instanceof EObject) {
            boolean _notEquals;
            EClass _eClass = ((EObject)object).eClass();
            EStructuralFeature eStructuralFeature = EObjectUtil.getEStructuralFeature((Object)_eClass, (String)"name");
            boolean bl = _notEquals = !Objects.equal((Object)eStructuralFeature, null);
            if (_notEquals) {
                Object _eGet = ((EObject)object).eGet(eStructuralFeature, false);
                String _string = null;
                if (_eGet != null) {
                    _string = _eGet.toString();
                }
                name = _string;
            } else {
                String _plus_1;
                EClass _eClass_1 = ((EObject)object).eClass();
                String _name = _eClass_1.getName();
                String _plus = String.valueOf(_name) + "@";
                int _hashCode = ((EObject)object).hashCode();
                String _hexString = Integer.toHexString(_hashCode);
                name = _plus_1 = String.valueOf(_plus) + _hexString;
            }
        } else if (object instanceof Resource) {
            String _lastSegment;
            URI _uRI = ((Resource)object).getURI();
            URI _trimQuery = _uRI.trimQuery();
            name = _lastSegment = _trimQuery.lastSegment();
        }
        return name;
    }

    public String getDiffKindText(Diff diff) {
        DifferenceKind kind;
        boolean _equals;
        DifferenceKind _kind = null;
        if (diff != null) {
            _kind = diff.getKind();
        }
        if (_equals = Objects.equal((Object)(kind = _kind), (Object)DifferenceKind.DELETE)) {
            if (diff instanceof ReferenceChange) {
                EReference reference = ((ReferenceChange)diff).getReference();
                boolean _isContainment = reference.isContainment();
                if (_isContainment) {
                    return "DELETED from ";
                }
                return "REMOVED from ";
            }
        } else {
            boolean _equals_1 = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
            if (_equals_1) {
                return "ADDED to ";
            }
        }
        return kind + "D ";
    }

    public String getDiffKindLabel(DifferenceKind kind) {
        if (kind != null) {
            switch (kind) {
                case ADD: {
                    return "+-";
                }
                case DELETE: {
                    return "-+";
                }
                case CHANGE: {
                    return "<>";
                }
                case MOVE: {
                    return "~";
                }
            }
            return "<>";
        }
        return "<>";
    }

    public Map<String, Object> handleDifferences(Comparison comparison, Diff diff) {
        boolean _notEquals;
        HashMap map = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        boolean bl = _notEquals = !Objects.equal((Object)diff, null);
        if (_notEquals) {
            DifferenceKind kind = diff.getKind();
            String _diffKindLabel = this.getDiffKindLabel(kind);
            map.put(MODEL_DIFF_REPORT_KIND, _diffKindLabel);
            StringBuffer _diffObjectURIFragment = this.getDiffObjectURIFragment(diff, DifferenceSource.LEFT);
            map.put(MODEL_DIFF_REPORT_LEFT_DIFF_URI, _diffObjectURIFragment);
            StringBuffer _diffObjectURIFragment_1 = this.getDiffObjectURIFragment(diff, DifferenceSource.RIGHT);
            map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_URI, _diffObjectURIFragment_1);
            if (diff instanceof AttributeChange) {
                StringBuffer _attributeChangeText = this.getAttributeChangeText((AttributeChange)diff);
                map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _attributeChangeText);
                StringBuffer _attributeChangeText_1 = this.getAttributeChangeText((AttributeChange)diff);
                map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _attributeChangeText_1);
            } else {
                DifferenceSource _source = diff.getSource();
                boolean _equals = Objects.equal((Object)_source, (Object)DifferenceSource.LEFT);
                if (_equals) {
                    boolean _equals_1 = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
                    if (_equals_1) {
                        StringBuffer _referenceChangeText = this.getReferenceChangeText(diff, false);
                        map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText);
                        StringBuffer _referenceChangeText_1 = this.getReferenceChangeText(diff, true);
                        map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_1);
                    } else {
                        boolean _equals_2 = Objects.equal((Object)kind, (Object)DifferenceKind.DELETE);
                        if (_equals_2) {
                            StringBuffer _referenceChangeText_2 = this.getReferenceChangeText(diff, false);
                            map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_2);
                            StringBuffer _referenceChangeText_3 = this.getReferenceChangeText(diff, true);
                            map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_3);
                        } else {
                            boolean _equals_3 = Objects.equal((Object)kind, (Object)DifferenceKind.MOVE);
                            if (_equals_3) {
                                StringBuffer _referenceChangeText_4 = this.getReferenceChangeText(diff, false);
                                map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_4);
                                StringBuffer _referenceChangeText_5 = this.getReferenceChangeText(diff, true);
                                map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_5);
                            }
                        }
                    }
                } else {
                    boolean _equals_4 = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
                    if (_equals_4) {
                        StringBuffer _referenceChangeText_6 = this.getReferenceChangeText(diff, true);
                        map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_6);
                        StringBuffer _referenceChangeText_7 = this.getReferenceChangeText(diff, false);
                        map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_7);
                    } else {
                        boolean _equals_5 = Objects.equal((Object)kind, (Object)DifferenceKind.DELETE);
                        if (_equals_5) {
                            StringBuffer _referenceChangeText_8 = this.getReferenceChangeText(diff, true);
                            map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_8);
                            StringBuffer _referenceChangeText_9 = this.getReferenceChangeText(diff, false);
                            map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_9);
                        } else {
                            boolean _equals_6 = Objects.equal((Object)kind, (Object)DifferenceKind.MOVE);
                            if (_equals_6) {
                                StringBuffer _referenceChangeText_10 = this.getReferenceChangeText(diff, true);
                                map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, _referenceChangeText_10);
                                StringBuffer _referenceChangeText_11 = this.getReferenceChangeText(diff, false);
                                map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, _referenceChangeText_11);
                            }
                        }
                    }
                }
            }
        }
        return map;
    }

    public StringBuffer getDiffObjectURIFragment(Diff diff, DifferenceSource source) {
        boolean _notEquals;
        StringBuffer _xblockexpression = null;
        StringBuffer label = new StringBuffer();
        EObject value = null;
        if (diff instanceof AttributeChange) {
            Match match = ((AttributeChange)diff).getMatch();
            EObject _xifexpression = null;
            boolean _equals = Objects.equal((Object)source, (Object)DifferenceSource.LEFT);
            _xifexpression = _equals ? match.getLeft() : match.getRight();
            value = _xifexpression;
        } else if (diff instanceof ReferenceChange) {
            EObject _value;
            Match _match = ((ReferenceChange)diff).getMatch();
            Comparison _comparison = _match.getComparison();
            value = _value = ModelCompareUtil.getValue(_comparison, diff);
        }
        boolean bl = _notEquals = !Objects.equal(value, null);
        if (_notEquals) {
            URI _uRI = EcoreResourceUtil.getURI(value);
            String _fragment = null;
            if (_uRI != null) {
                _fragment = _uRI.fragment();
            }
            label.append(_fragment);
        }
        _xblockexpression = label;
        return _xblockexpression;
    }

    public StringBuffer getAttributeChangeText(AttributeChange attributeChange) {
        boolean _notEquals;
        StringBuffer _xblockexpression = null;
        StringBuffer label = new StringBuffer();
        boolean bl = _notEquals = !Objects.equal((Object)attributeChange, null);
        if (_notEquals) {
            EAttribute _attribute = attributeChange.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            String _plus = "[" + _name;
            String _plus_1 = String.valueOf(_plus) + " ";
            DifferenceKind _kind = attributeChange.getKind();
            String _plus_2 = String.valueOf(_plus_1) + _kind;
            String _plus_3 = String.valueOf(_plus_2) + "D";
            String _plus_4 = String.valueOf(_plus_3) + "]";
            label.append(_plus_4);
        }
        _xblockexpression = label;
        return _xblockexpression;
    }

    public StringBuffer getReferenceChangeText(Diff diff, boolean opposite) {
        StringBuffer _xblockexpression = null;
        StringBuffer label = new StringBuffer();
        if (diff instanceof ReferenceChange) {
            DifferenceKind kind = ((ReferenceChange)diff).getKind();
            String kindLabel = "";
            if (!opposite) {
                String _diffKindText;
                kindLabel = _diffKindText = this.getDiffKindText(diff);
            } else {
                boolean _equals = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
                if (_equals) {
                    boolean _not;
                    kindLabel = "DELETED from ";
                    EReference reference = ((ReferenceChange)diff).getReference();
                    boolean _isContainment = reference.isContainment();
                    boolean bl = _not = !_isContainment;
                    if (_not) {
                        kindLabel = "REMOVED from ";
                    }
                } else {
                    String _plus;
                    boolean _equals_1 = Objects.equal((Object)kind, (Object)DifferenceKind.DELETE);
                    kindLabel = _equals_1 ? "ADDED to " : (_plus = kind + "D ");
                }
            }
            EObject _xifexpression = null;
            if (!opposite) {
                Match _match = ((ReferenceChange)diff).getMatch();
                _xifexpression = _match.getLeft();
            } else {
                Match _match_1 = ((ReferenceChange)diff).getMatch();
                _xifexpression = _match_1.getRight();
            }
            EObject matchValue = _xifexpression;
            StringBuffer _append = label.append(" [");
            StringBuffer _append_1 = _append.append(kindLabel);
            String _name = this.getName(matchValue);
            String _plus_1 = String.valueOf(_name) + ".";
            EReference _reference = ((ReferenceChange)diff).getReference();
            String _name_1 = null;
            if (_reference != null) {
                _name_1 = _reference.getName();
            }
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            StringBuffer _append_2 = _append_1.append(_plus_2);
            return _append_2.append("]");
        }
        _xblockexpression = label;
        return _xblockexpression;
    }

    public void writeFile(IFile targetFile, CharSequence content) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            boolean _exists = targetFile.exists();
            if (_exists) {
                targetFile.delete(true, (IProgressMonitor)monitor);
            }
            String _string = content.toString();
            byte[] _bytes = _string.getBytes();
            ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
            targetFile.create((InputStream)_byteArrayInputStream, true, (IProgressMonitor)monitor);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void createFolder(IFolder folder) {
        try {
            boolean _not;
            NullProgressMonitor monitor = new NullProgressMonitor();
            boolean _exists = folder.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                folder.create(true, false, (IProgressMonitor)monitor);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }
}

