/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.editors.forms.BasicTransactionalFormEditor;
import org.eclipse.sphinx.emf.editors.forms.internal.Activator;
import org.eclipse.sphinx.emf.ui.actions.ExtendedCopyAction;
import org.eclipse.sphinx.emf.ui.actions.ExtendedCutAction;
import org.eclipse.sphinx.emf.ui.actions.ExtendedDeleteAction;
import org.eclipse.sphinx.emf.ui.actions.ExtendedPasteAction;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class BasicTransactionalEditorActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    public static final String VIEW_POINT = "org.eclipse.sphinx.emf.editors.forms.actionBarValidateAction";
    public static final String VALIDATEACTION = "validateAction";
    public static final String CLASS_ATTR = "class";
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new ShowPropertiesViewAction();
    protected IAction refreshAction;
    protected Collection<IAction> createChildActions;
    protected Map<String, Collection<IAction>> createChildSubmenuActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected Map<String, Collection<IAction>> createSiblingSubmenuActions;
    protected IMenuManager createSiblingMenuManager;

    private static String getStringFromKey(String key) {
        try {
            return Activator.INSTANCE.getString(key);
        }
        catch (MissingResourceException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return String.valueOf(key) + " (not found)";
        }
    }

    public BasicTransactionalEditorActionBarContributor() {
        super(1);
    }

    public void setGlobalActionHandlers() {
        this.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void clearGlobalActionHandlers() {
        this.getActionBars().clearGlobalActionHandlers();
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = this.createDeleteAction();
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.cutAction = this.createCutAction();
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.copyAction = this.createCopyAction();
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.pasteAction = this.createPasteAction();
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.undoAction = this.createUndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = this.createRedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setGlobalActionHandlers();
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(VIEW_POINT);
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfgElem = iConfigurationElementArray[n2];
            if (VALIDATEACTION.equals(cfgElem.getName())) {
                try {
                    this.validateAction = (ValidateAction)cfgElem.createExecutableExtension(CLASS_ATTR);
                }
                catch (CoreException ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex.getMessage());
                }
            }
            ++n2;
        }
    }

    protected DeleteAction createDeleteAction() {
        return new ExtendedDeleteAction(this.removeAllReferencesOnDelete(), this.getCustomAdapterFactory());
    }

    protected PasteAction createPasteAction() {
        return new ExtendedPasteAction(this.getCustomAdapterFactory());
    }

    protected CopyAction createCopyAction() {
        return new ExtendedCopyAction(this.getCustomAdapterFactory());
    }

    protected CutAction createCutAction() {
        return new ExtendedCutAction(this.getCustomAdapterFactory());
    }

    protected RedoAction createRedoAction() {
        return new RedoActionWrapper();
    }

    protected UndoAction createUndoAction() {
        return new UndoActionWrapper();
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(BasicTransactionalEditorActionBarContributor.getStringFromKey("_UI_Editor_menu"));
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(BasicTransactionalEditorActionBarContributor.getStringFromKey("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(BasicTransactionalEditorActionBarContributor.getStringFromKey("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            if (this.selectionProvider != null) {
                this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                if (this.selectionProvider.getSelection() != null) {
                    this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
        ArrayList nonEditorInputObjects = new ArrayList();
        for (Object selected : structuredSelection.toList()) {
            BasicTransactionalFormEditor activeFormEditor;
            if (!(this.activeEditor instanceof BasicTransactionalFormEditor) || selected == (activeFormEditor = (BasicTransactionalFormEditor)this.activeEditor).getEditorInputObject()) continue;
            nonEditorInputObjects.add(selected);
        }
        StructuredSelection nonModelRootSelection = new StructuredSelection(nonEditorInputObjects);
        this.deleteAction.selectionChanged((IStructuredSelection)nonModelRootSelection);
        this.cutAction.selectionChanged((IStructuredSelection)nonModelRootSelection);
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildSubmenuActions);
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingSubmenuActions);
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection<?> newChildDescriptors = null;
        Collection<?> newSiblingDescriptors = null;
        if (structuredSelection.size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditor).getEditingDomain();
            if (domain instanceof TransactionalEditingDomain) {
                newChildDescriptors = this.getNewChildDescriptors((TransactionalEditingDomain)domain, object, null);
                newSiblingDescriptors = this.getNewChildDescriptors((TransactionalEditingDomain)domain, null, object);
            }
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createChildSubmenuActions = this.extractSubmenuActions(this.createChildActions, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        this.createSiblingSubmenuActions = this.extractSubmenuActions(this.createSiblingActions, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildSubmenuActions, null);
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingSubmenuActions, null);
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection<?> getNewChildDescriptors(TransactionalEditingDomain editingDomain, Object object, Object sibling) {
        IEditingDomainItemProvider editingDomainItemProvider;
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        if (adapterFactory != null && (editingDomainItemProvider = (IEditingDomainItemProvider)adapterFactory.adapt(object, IEditingDomainItemProvider.class)) != null) {
            return editingDomainItemProvider.getNewChildDescriptors(object, (EditingDomain)editingDomain, sibling);
        }
        return Collections.emptyList();
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(BasicTransactionalEditorActionBarContributor.getStringFromKey("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildSubmenuActions, null);
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(BasicTransactionalEditorActionBarContributor.getStringFromKey("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingSubmenuActions, null);
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)this.createCreateChildAction(this.activeEditor, selection, descriptor));
            }
            Collections.sort(actions, new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
                }
            });
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)this.createCreateSiblingAction(this.activeEditor, selection, descriptor));
            }
            Collections.sort(actions, new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
                }
            });
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionId) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionId != null) {
                    manager.insertBefore(contributionId, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void populateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions, String contributionId) {
        if (submenuActions != null) {
            for (Map.Entry<String, Collection<IAction>> entry : submenuActions.entrySet()) {
                MenuManager submenuManager = new MenuManager(entry.getKey());
                if (contributionId != null) {
                    manager.insertBefore(contributionId, (IContributionItem)submenuManager);
                } else {
                    manager.add((IContributionItem)submenuManager);
                }
                this.populateManager((IContributionManager)submenuManager, entry.getValue(), null);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem contributionItem = iContributionItemArray[n2];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions) {
        if (submenuActions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuManager submenuManager;
                IContributionItem contributionItem = iContributionItemArray[n2];
                if (contributionItem instanceof MenuManager && submenuActions.containsKey((submenuManager = (MenuManager)contributionItem).getMenuText())) {
                    this.depopulateManager((IContributionManager)submenuManager, submenuActions.get(contributionItem));
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    protected Map<String, Collection<IAction>> extractSubmenuActions(Collection<IAction> createActions, ISelection selection) {
        LinkedHashMap<String, Collection<IAction>> createSubmenuActions = new LinkedHashMap<String, Collection<IAction>>();
        if (createActions != null) {
            Iterator<IAction> actions = createActions.iterator();
            while (actions.hasNext()) {
                IAction action = actions.next();
                StringTokenizer st = new StringTokenizer(action.getText(), "|");
                if (st.countTokens() != 2) continue;
                String text = st.nextToken().trim();
                IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
                if (structuredSelection.getFirstElement() instanceof TransientItemProvider) {
                    action.setText(st.nextToken().trim());
                    continue;
                }
                ArrayList<IAction> submenuActions = (ArrayList<IAction>)createSubmenuActions.get(text);
                if (submenuActions == null) {
                    submenuActions = new ArrayList<IAction>();
                    createSubmenuActions.put(text, submenuActions);
                }
                action.setText(st.nextToken().trim());
                submenuActions.add(action);
                actions.remove();
            }
        }
        return createSubmenuActions;
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        if (this.showPropertiesViewAction != null || this.refreshAction != null) {
            menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        }
        if (this.showPropertiesViewAction != null) {
            menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        }
        if (this.refreshAction != null) {
            this.refreshAction.setEnabled(this.refreshAction.isEnabled());
            menuManager.insertAfter("ui-actions", this.refreshAction);
        }
        super.addGlobalActions(menuManager);
    }

    protected CreateChildAction createCreateChildAction(IEditorPart editorPart, ISelection selection, Object descriptor) {
        return new CreateChildAction(this.activeEditor, selection, descriptor);
    }

    protected CreateSiblingAction createCreateSiblingAction(IEditorPart editorPart, ISelection selection, Object descriptor) {
        return new CreateSiblingAction(this.activeEditor, selection, descriptor);
    }

    public class RefreshAction
    extends Action {
        public RefreshAction() {
            super(BasicTransactionalEditorActionBarContributor.getStringFromKey("_UI_Refresh_menu_item"));
        }

        public boolean isEnabled() {
            return BasicTransactionalEditorActionBarContributor.this.activeEditor instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (BasicTransactionalEditorActionBarContributor.this.activeEditor instanceof IViewerProvider && (viewer = ((IViewerProvider)BasicTransactionalEditorActionBarContributor.this.activeEditor).getViewer()) != null) {
                viewer.refresh();
            }
        }
    }

    public class ShowPropertiesViewAction
    extends Action {
        public ShowPropertiesViewAction() {
            super(BasicTransactionalEditorActionBarContributor.getStringFromKey("_UI_ShowPropertiesView_menu_item"));
        }

        public void run() {
            try {
                BasicTransactionalEditorActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)exception));
            }
        }
    }
}

