/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.splitting.IModelSplitOperation;
import org.eclipse.sphinx.emf.splitting.IModelSplitPolicy;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.operations.BasicModelSplitOperation;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.platform.jobs.WorkspaceOperationWorkspaceJob;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.ui.operations.RunnableWithProgressAdapter;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicModelSplitAction
extends BaseSelectionListenerAction {
    protected URI resourceURI;
    protected IModelSplitPolicy modelSplitPolicy;
    private boolean runInBackground;

    public BasicModelSplitAction(String text, IModelSplitPolicy modelSplitPolicy) {
        super(text);
        Assert.isNotNull((Object)modelSplitPolicy);
        this.modelSplitPolicy = modelSplitPolicy;
        this.setRunInBackground(false);
    }

    public boolean isRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object selected;
        this.resourceURI = null;
        if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof IFile) {
            this.resourceURI = EcorePlatformUtil.createURI((IPath)((IFile)selected).getFullPath());
        }
        return this.resourceURI != null;
    }

    protected IModelSplitOperation createModelSplitOperation() {
        return new BasicModelSplitOperation(this.resourceURI, this.modelSplitPolicy);
    }

    protected WorkspaceOperationWorkspaceJob createWorkspaceOperationJob(IModelSplitOperation operation) {
        return new WorkspaceOperationWorkspaceJob((IWorkspaceOperation)operation);
    }

    public void run() {
        IModelSplitOperation operation = this.createModelSplitOperation();
        if (this.isRunInBackground()) {
            WorkspaceOperationWorkspaceJob job = this.createWorkspaceOperationJob(operation);
            job.schedule();
        } else {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(ExtendedPlatformUI.getActiveShell());
                dialog.run(true, true, (IRunnableWithProgress)new RunnableWithProgressAdapter((IWorkspaceOperation)operation));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
    }
}

