/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.sphinx.emf.ui.properties.filters.IPropertySourceFilter;
import org.eclipse.sphinx.emf.ui.properties.filters.PropertySourceFilterRegistry;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class FilteringPropertySource
implements IPropertySource {
    IPropertySource propertySourceDelegate;
    IPropertySourceFilter propertySourceFilter;

    public FilteringPropertySource(IPropertySource propertySourceDelegate) {
        Assert.isNotNull((Object)propertySourceDelegate);
        this.propertySourceDelegate = propertySourceDelegate;
    }

    public IPropertySourceFilter getPropertySourceFilter() {
        if (this.propertySourceFilter == null) {
            Object owner = this.propertySourceDelegate.getEditableValue();
            this.propertySourceFilter = PropertySourceFilterRegistry.INSTANCE.getPropertySourceFilter(owner);
        }
        return this.propertySourceFilter;
    }

    public Object getEditableValue() {
        return this.propertySourceDelegate.getEditableValue();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getPropertySourceFilter() != null) {
            return this.getPropertySourceFilter().getAcceptedPropertyDescriptors(this.propertySourceDelegate);
        }
        return this.propertySourceDelegate.getPropertyDescriptors();
    }

    public Object getPropertyValue(Object id) {
        return this.propertySourceDelegate.getPropertyValue(id);
    }

    public boolean isPropertySet(Object id) {
        return this.propertySourceDelegate.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        this.propertySourceDelegate.resetPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        this.propertySourceDelegate.setPropertyValue(id, value);
    }
}

