/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sphinx.emf.check.Check;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.emf.check.CheckValidatorState;
import org.eclipse.sphinx.emf.check.ICheckValidator;
import org.eclipse.sphinx.emf.check.catalog.Catalog;
import org.eclipse.sphinx.emf.check.catalog.Category;

public class CheckMethodWrapper {
    private Method method;
    private Check checkAnnotation;
    private ICheckValidator validator;
    private CheckValidatorRegistry checkValidatorRegistry;

    public CheckMethodWrapper(ICheckValidator validator, Method method, CheckValidatorRegistry checkValidatorRegistry) {
        Assert.isNotNull((Object)validator);
        Assert.isNotNull((Object)method);
        Assert.isNotNull((Object)checkValidatorRegistry);
        Assert.isNotNull((Object)method.getAnnotation(Check.class));
        this.validator = validator;
        this.method = method;
        this.checkAnnotation = method.getAnnotation(Check.class);
        this.checkValidatorRegistry = checkValidatorRegistry;
    }

    public ICheckValidator getValidator() {
        return this.validator;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getAnnotatedConstraint() {
        return this.checkAnnotation.constraint();
    }

    public Set<String> getAnnotatedCategories() {
        String[] categories = this.checkAnnotation.categories();
        if (!(categories.length <= 0 || categories.length <= 1 && categories[0].isEmpty())) {
            return new HashSet<String>(Arrays.asList(categories));
        }
        return Collections.emptySet();
    }

    private boolean isOtherCategorySelected(Set<String> selectedCategories) {
        Assert.isNotNull(selectedCategories);
        for (String categoryId : selectedCategories) {
            if (!categoryId.equals("org.eclipse.sphinx.emf.check.categories.other")) continue;
            return true;
        }
        return false;
    }

    public void invoke(CheckValidatorState state, Set<String> selectedCategories) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean wasNull;
        if (this.validator.getState().get() != null && this.validator.getState().get() != state) {
            throw new IllegalStateException("State is already assigned.");
        }
        boolean bl = wasNull = this.validator.getState().get() == null;
        if (wasNull) {
            this.validator.getState().set(state);
        }
        try {
            if (!state.checkValidationMode.shouldCheck(this.checkAnnotation.value())) {
                return;
            }
            if (selectedCategories.isEmpty()) {
                this.invokeInternal(state);
            } else {
                HashSet<String> categories = new HashSet<String>();
                categories.addAll(selectedCategories);
                Set<String> annotatedCategories = this.getAnnotatedCategories();
                Catalog catalog = this.checkValidatorRegistry.getCheckCatalog(this.validator);
                if (this.getAnnotatedConstraint().isEmpty()) {
                    if (this.isOtherCategorySelected(selectedCategories)) {
                        this.invokeInternal(state);
                    }
                } else if (annotatedCategories.isEmpty()) {
                    if (catalog != null && !catalog.getCategories().isEmpty()) {
                        this.retainAll(categories, (EList<Category>)catalog.getCategories());
                        if (!categories.isEmpty()) {
                            this.invokeInternal(state);
                        }
                    }
                } else {
                    categories.retainAll(annotatedCategories);
                    if (catalog != null && !catalog.getCategories().isEmpty()) {
                        this.retainAll(categories, (EList<Category>)catalog.getCategories());
                    }
                    if (!categories.isEmpty()) {
                        this.invokeInternal(state);
                    }
                }
            }
        }
        finally {
            if (wasNull) {
                this.validator.getState().set(null);
            }
        }
    }

    protected void invokeInternal(CheckValidatorState state) throws IllegalAccessException, InvocationTargetException {
        state.currentMethod = this.method;
        state.currentCheckType = this.checkAnnotation.value();
        state.constraint = this.getAnnotatedConstraint();
        this.method.setAccessible(true);
        this.method.invoke((Object)this.validator, state.currentObject);
    }

    private void retainAll(Set<String> categories, EList<Category> categoryList) {
        HashSet<String> categoryIDs = new HashSet<String>();
        for (Category category : categoryList) {
            categoryIDs.add(category.getId());
        }
        categories.retainAll(categoryIDs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckMethodWrapper other = (CheckMethodWrapper)obj;
        if (!this.method.equals(other.method)) {
            return false;
        }
        return this.validator.equals(other.validator);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.validator.hashCode();
        return result;
    }

    public String toString() {
        return "CheckMethodWrapper [method=" + this.method + "]";
    }
}

