/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.internal.messages.Messages;

public class DirectedGraph<V> {
    private Set<Edge> edges = new HashSet<Edge>();
    private boolean allowLoops;
    private boolean allowMultipleEdges;
    private DirectedGraphInternal graphInternal = new DirectedGraphInternal();

    public DirectedGraph(boolean allowLoops, boolean allowMultipleEdges) {
        this.allowLoops = allowLoops;
        this.allowMultipleEdges = allowMultipleEdges;
    }

    protected boolean assertVertexExist(V vertex) {
        if (this.containsVertex(vertex)) {
            return true;
        }
        if (vertex == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.error_NoSuchVertex, vertex));
    }

    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(vertex)) {
            return false;
        }
        this.graphInternal.addVertex(vertex);
        return true;
    }

    public boolean containsVertex(V vertex) {
        return this.graphInternal.getVertexSet().contains(vertex);
    }

    public Set<Edge> outgoingEdgesOf(V vertex) {
        return this.graphInternal.outgoingEdgesOf(vertex);
    }

    public Set<Edge> incomingEdgesOf(V vertex) {
        return this.graphInternal.incomingEdgesOf(vertex);
    }

    public int inDegreeOf(V vertex) {
        return this.graphInternal.inDegreeOf(vertex);
    }

    public int outDegreeOf(V vertex) {
        return this.graphInternal.outDegreeOf(vertex);
    }

    public Edge addEdge(V srcVertex, V trgtVertex) {
        this.assertVertexExist(srcVertex);
        this.assertVertexExist(trgtVertex);
        if (!this.allowMultipleEdges && this.containsEdge(srcVertex, trgtVertex)) {
            return null;
        }
        if (!this.allowLoops && srcVertex.equals(trgtVertex)) {
            throw new IllegalArgumentException(Messages.error_LoopsNotAllowed);
        }
        Edge edge = new Edge(srcVertex, trgtVertex);
        if (this.containsEdge(edge)) {
            return null;
        }
        this.edges.add(edge);
        this.graphInternal.addEdgeToTouchingVertices(edge);
        return edge;
    }

    public boolean containsEdge(Edge edge) {
        return this.edges.contains(edge);
    }

    public boolean containsEdge(V srcVertex, V trgtVertex) {
        return this.getEdge(srcVertex, trgtVertex) != null;
    }

    public Edge getEdge(V srcVertex, V trgtVertex) {
        return this.graphInternal.getEdge(srcVertex, trgtVertex);
    }

    protected class DirectedEdgeContainer {
        Set<Edge> incomingEdges = new HashSet<Edge>();
        Set<Edge> outgoingEdges = new HashSet<Edge>();
        private transient Set<Edge> unmodifiableIncoming = null;
        private transient Set<Edge> unmodifiableOutgoing = null;

        protected DirectedEdgeContainer() {
        }

        public Set<Edge> getUnmodifiableIncomingEdges() {
            if (this.unmodifiableIncoming == null) {
                this.unmodifiableIncoming = Collections.unmodifiableSet(this.incomingEdges);
            }
            return this.unmodifiableIncoming;
        }

        public Set<Edge> getUnmodifiableOutgoingEdges() {
            if (this.unmodifiableOutgoing == null) {
                this.unmodifiableOutgoing = Collections.unmodifiableSet(this.outgoingEdges);
            }
            return this.unmodifiableOutgoing;
        }

        public void addIncomingEdge(Edge edge) {
            this.incomingEdges.add(edge);
        }

        public void addOutgoingEdge(Edge edge) {
            this.outgoingEdges.add(edge);
        }

        public void removeIncomingEdge(Edge edge) {
            this.incomingEdges.remove(edge);
        }

        public void removeOutgoingEdge(Edge edge) {
            this.outgoingEdges.remove(edge);
        }
    }

    protected class DirectedGraphInternal {
        private Map<V, DirectedEdgeContainer> verticesMap = new LinkedHashMap();

        protected DirectedGraphInternal() {
        }

        protected void addVertex(V v) {
            this.verticesMap.put(v, null);
        }

        public Set<V> getVertexSet() {
            return this.verticesMap.keySet();
        }

        public int inDegreeOf(V vertex) {
            return this.getEdgeContainer(vertex).incomingEdges.size();
        }

        public Set<Edge> incomingEdgesOf(V vertex) {
            return this.getEdgeContainer(vertex).getUnmodifiableIncomingEdges();
        }

        public int outDegreeOf(V vertex) {
            return this.getEdgeContainer(vertex).outgoingEdges.size();
        }

        public Set<Edge> outgoingEdgesOf(V vertex) {
            return this.getEdgeContainer(vertex).getUnmodifiableOutgoingEdges();
        }

        public void addEdgeToTouchingVertices(Edge edge) {
            Object source = edge.getSource();
            Object target = edge.getTarget();
            this.getEdgeContainer(source).addOutgoingEdge(edge);
            this.getEdgeContainer(target).addIncomingEdge(edge);
        }

        public Edge getEdge(V srcVertex, V trgtVertex) {
            if (DirectedGraph.this.containsVertex(srcVertex) && DirectedGraph.this.containsVertex(trgtVertex)) {
                DirectedEdgeContainer edgeContainer = this.getEdgeContainer(srcVertex);
                for (Edge edge : edgeContainer.outgoingEdges) {
                    if (!edge.getTarget().equals(trgtVertex)) continue;
                    return edge;
                }
            }
            return null;
        }

        private DirectedEdgeContainer getEdgeContainer(V vertex) {
            if (this.getVertexSet().contains(vertex)) {
                DirectedEdgeContainer edgeContainer = this.verticesMap.get(vertex);
                if (edgeContainer == null) {
                    edgeContainer = new DirectedEdgeContainer();
                    this.verticesMap.put((DirectedEdgeContainer)vertex, edgeContainer);
                }
                return edgeContainer;
            }
            if (vertex == null) {
                throw new NullPointerException();
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.error_NoSuchVertex, vertex));
        }
    }

    public class Edge {
        private V sourceVertex;
        private V targetVertex;

        public Edge(V srcVertex, V trgtVertex) {
            this.sourceVertex = srcVertex;
            this.targetVertex = trgtVertex;
        }

        public V getSource() {
            return this.sourceVertex;
        }

        public V getTarget() {
            return this.targetVertex;
        }

        public String toString() {
            return NLS.bind((String)Messages.toString_Edge, this.sourceVertex, this.targetVertex);
        }
    }
}

