/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.validation.ui.Activator;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerResolutionDialog;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSelectionProviderAction;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerView;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ActionResolveMarker
extends MarkerSelectionProviderAction {
    private MarkerView view;

    public ActionResolveMarker(MarkerView markerView, ISelectionProvider provider) {
        super(provider, MarkerMessages.resolveMarkerAction_title);
        this.setEnabled(false);
        this.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_ELCL_QUICK_FIX_ENABLED"));
        this.setDisabledImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_DLCL_QUICK_FIX_DISABLED"));
        this.view = markerView;
    }

    public void run() {
        ProgressMonitorDialog context = new ProgressMonitorDialog(this.view.getSite().getShell());
        final Object[] resolutions = new Object[1];
        IRunnableWithProgress resolutionsRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(NLS.bind((String)MarkerMessages.resolveMarkerAction_computationAction, (Object)ActionResolveMarker.this.getMarkerDescription()), 100);
                monitor.worked(25);
                resolutions[0] = IDE.getMarkerHelpRegistry().getResolutions(ActionResolveMarker.this.getSelectedMarker());
                monitor.done();
            }
        };
        Object service = this.view.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        try {
            if (service == null) {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, resolutionsRunnable, null);
            } else {
                ((IWorkbenchSiteProgressService)service).runInUI((IRunnableContext)context, resolutionsRunnable, null);
            }
        }
        catch (InvocationTargetException exception) {
            this.handleException(exception);
            return;
        }
        catch (InterruptedException exception) {
            this.handleException(exception);
            return;
        }
        IMarkerResolution[] foundResolutions = (IMarkerResolution[])resolutions[0];
        if (foundResolutions.length == 0) {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)MarkerMessages.MarkerResolutionDialog_CannotFixTitle, (String)NLS.bind((String)MarkerMessages.MarkerResolutionDialog_CannotFixMessage, (Object)this.getMarkerDescription()));
        } else {
            Dialog dialog = this.createMarkerResolutionDialog(foundResolutions, this.getSelectedMarker());
            dialog.open();
        }
    }

    protected Dialog createMarkerResolutionDialog(IMarkerResolution[] resolutions, IMarker selectedMarker) {
        return new MarkerResolutionDialog(this.view.getSite().getShell(), selectedMarker, resolutions, this.view);
    }

    protected MarkerView getMarkerView() {
        return this.view;
    }

    private void handleException(Exception exception) {
        PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)exception);
        ErrorDialog.openError((Shell)this.view.getSite().getShell(), (String)MarkerMessages.Error, (String)NLS.bind((String)MarkerMessages.MarkerResolutionDialog_CannotFixMessage, (Object)this.getMarkerDescription()), (IStatus)Util.errorStatus(exception));
    }

    private String getMarkerDescription() {
        return Util.getProperty("message", this.getSelectedMarker());
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (Util.isSingleConcreteSelection(selection) && IDE.getMarkerHelpRegistry().hasResolutions(this.getSelectedMarker())) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

