/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.emf.compare.reports.csv;

import com.google.common.base.Objects;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.sphinx.emf.compare.report.AbstractModelCompareReportGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ModelCompareCSVReportGenerator
extends AbstractModelCompareReportGenerator {
    private static final String MODEL_DIFF_REPORT_TARGET_CSV_FILE_NAME = "{0}_{1}_diffs.csv";
    private static final String SEPARATOR = ";";

    protected CharSequence doGenerate(Comparison comparison) {
        return this.generateCVS(comparison);
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
        this.generate(comparison);
    }

    public void generate(Comparison comparison) {
        boolean _notEquals;
        IProject targetProject = this.getTargetProject(comparison);
        boolean bl = _notEquals = !Objects.equal((Object)targetProject, null);
        if (_notEquals) {
            boolean _not;
            IFolder folder = targetProject.getFolder("reports");
            boolean _exists = folder.exists();
            boolean bl2 = _not = !_exists;
            if (_not) {
                this.createFolder(folder);
            }
            IFile targetFile = folder.getFile(MessageFormat.format(MODEL_DIFF_REPORT_TARGET_CSV_FILE_NAME, this.getName(this.getLeftObject(comparison)), this.getName(this.getRightObject(comparison))));
            this.generate(comparison, targetFile);
        }
    }

    public CharSequence generateCVS(Comparison comparison) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
        if (_notEquals) {
            Notifier leftObject = this.getLeftObject(comparison);
            _builder.newLineIfNotEmpty();
            Notifier rightObject = this.getRightObject(comparison);
            _builder.newLineIfNotEmpty();
            _builder.append("Model Differences");
            _builder.append(SEPARATOR);
            _builder.append(SEPARATOR);
            _builder.append(SEPARATOR);
            _builder.append(SEPARATOR);
            _builder.newLineIfNotEmpty();
            _builder.append("Left: ");
            String _modelCompareInputText = this.getModelCompareInputText(leftObject);
            _builder.append(_modelCompareInputText);
            _builder.append(SEPARATOR);
            _builder.append(SEPARATOR);
            _builder.append("  ");
            _builder.append(SEPARATOR);
            _builder.append("Right: ");
            String _modelCompareInputText_1 = this.getModelCompareInputText(rightObject);
            _builder.append(_modelCompareInputText_1);
            _builder.append(SEPARATOR);
            _builder.newLineIfNotEmpty();
            EList _differences = comparison.getDifferences();
            for (Diff diff : _differences) {
                Map differences = this.handleDifferences(comparison, diff);
                _builder.newLineIfNotEmpty();
                Object _get = differences.get("leftURI");
                _builder.append(_get);
                _builder.append(SEPARATOR);
                Object _get_1 = differences.get("leftChangeText");
                _builder.append(_get_1);
                _builder.append(SEPARATOR);
                Object _get_2 = differences.get("kind");
                _builder.append(_get_2);
                _builder.append(SEPARATOR);
                Object _get_3 = differences.get("rightURI");
                _builder.append(_get_3);
                _builder.append(SEPARATOR);
                Object _get_4 = differences.get("rightChangeText");
                _builder.append(_get_4);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }
}

