/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.referentialintegrity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.URIExtensions;
import org.eclipse.sphinx.emf.workspace.internal.referentialintegrity.IntermittentRemoveTracker;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeDetectorDelegate;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeNotification;

public abstract class AbstractHierarchicalFragmentURIChangeDetectorDelegate
implements IURIChangeDetectorDelegate {
    protected final IntermittentRemoveTracker removedContentsTracker = this.createIntermittentRemoveTracker();

    protected IntermittentRemoveTracker createIntermittentRemoveTracker() {
        return new IntermittentRemoveTracker();
    }

    protected abstract boolean affectsURIFragmentSegmentOfChangedObject(Notification var1);

    @Override
    public Map<Resource, List<URIChangeNotification>> detectChangedURIs(List<Notification> notifications) {
        if (notifications != null) {
            HashMap<Resource, List<URIChangeNotification>> resourceToUriChangeNotification = new HashMap<Resource, List<URIChangeNotification>>(notifications.size());
            for (Notification notification : notifications) {
                Object notifierObj = notification.getNotifier();
                if (!(notifierObj instanceof EObject)) continue;
                EObject notifier = (EObject)notifierObj;
                Resource resource = notifier.eResource();
                List<URIChangeNotification> uriNotifications = this.handleNotification(notification, notifier);
                if (uriNotifications == null || uriNotifications.isEmpty()) continue;
                if (resourceToUriChangeNotification.get(resource) == null) {
                    resourceToUriChangeNotification.put(resource, uriNotifications);
                    continue;
                }
                ((List)resourceToUriChangeNotification.get(resource)).addAll(uriNotifications);
            }
            return resourceToUriChangeNotification;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<URIChangeNotification> detectChangedURIs(Notification notification) {
        Object notifierObj;
        if (notification != null && (notifierObj = notification.getNotifier()) instanceof EObject) {
            return this.handleNotification(notification, (EObject)notifierObj);
        }
        return Collections.emptyList();
    }

    protected List<URIChangeNotification> handleNotification(Notification notification, EObject notifier) {
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (this.affectsURIFragmentSegmentOfChangedObject(notification)) {
            return this.handleURIFragmentSegmentChange(notification, notifier);
        }
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            return this.handleContainmentChange(notification, notifier, feature);
        }
        return Collections.emptyList();
    }

    protected List<URIChangeNotification> handleURIFragmentSegmentChange(Notification notification, EObject eObject) {
        URI newURI = EcoreResourceUtil.getURI((EObject)eObject);
        URI oldURI = URIExtensions.replaceLastFragmentSegment((URI)newURI, (String)notification.getNewStringValue(), (String)notification.getOldStringValue());
        if (oldURI != null && !oldURI.equals(newURI)) {
            return this.addURIChangeNotification(eObject, oldURI, newURI);
        }
        return Collections.emptyList();
    }

    protected List<URIChangeNotification> handleContainmentChange(Notification notification, EObject eObject, EStructuralFeature feature) {
        this.removedContentsTracker.clearObsoleteEntries();
        if (4 == notification.getEventType()) {
            URI containerURI = EcoreResourceUtil.getURI((EObject)eObject);
            if (notification.getOldValue() instanceof EObject) {
                this.handleRemovedContent(eObject, containerURI, feature, (EObject)notification.getOldValue());
            }
        } else {
            if (3 == notification.getEventType()) {
                return this.handleAddedContent((EObject)notification.getNewValue());
            }
            if (6 == notification.getEventType()) {
                URI containerURI = EcoreResourceUtil.getURI((EObject)eObject);
                List oldValues = (List)notification.getOldValue();
                for (Object oldValue : oldValues) {
                    if (!(oldValue instanceof EObject)) continue;
                    this.handleRemovedContent(eObject, containerURI, feature, (EObject)oldValue);
                }
            } else if (5 == notification.getEventType()) {
                List newValues = (List)notification.getNewValue();
                ArrayList<URIChangeNotification> notifications = new ArrayList<URIChangeNotification>(newValues.size());
                for (Object newValue : newValues) {
                    if (!(newValue instanceof EObject)) continue;
                    notifications.addAll(this.handleAddedContent((EObject)newValue));
                }
                return notifications;
            }
        }
        return Collections.emptyList();
    }

    protected void handleRemovedContent(EObject oldContainer, URI oldContainerURI, EStructuralFeature oldFeature, EObject oldContent) {
        URI oldContentURI = null;
        if (oldContent.eResource() == null) {
            oldContentURI = EcoreResourceUtil.getURI((EObject)oldContainer, (EStructuralFeature)oldFeature, (EObject)oldContent);
        } else {
            URI newContentURI = EcoreResourceUtil.getURI((EObject)oldContent);
            URI newContainerURI = EcoreResourceUtil.getURI((EObject)oldContent.eContainer());
            oldContentURI = URIExtensions.replaceBaseURI((URI)newContentURI, (URI)newContainerURI, (URI)oldContainerURI);
        }
        if (oldContentURI != null) {
            this.removedContentsTracker.put(oldContent, oldContentURI);
        }
    }

    protected List<URIChangeNotification> handleAddedContent(EObject newContent) {
        URI newContentURI;
        URI oldContentURI = (URI)this.removedContentsTracker.get(newContent);
        if (oldContentURI != null && !oldContentURI.equals(newContentURI = EcoreResourceUtil.getURI((EObject)newContent))) {
            return this.addURIChangeNotification(newContent, oldContentURI, newContentURI);
        }
        return Collections.emptyList();
    }

    protected List<URIChangeNotification> addURIChangeNotification(EObject eObject, URI oldURI, URI newURI) {
        LinkedList<URIChangeNotification> notifications = new LinkedList<URIChangeNotification>();
        notifications.add(new URIChangeNotification(eObject, oldURI));
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EObject contentObject = (EObject)eAllContents.next();
            URI newContentURI = EcoreResourceUtil.getURI((EObject)contentObject);
            URI oldContentURI = URIExtensions.replaceBaseURI((URI)newContentURI, (URI)newURI, (URI)oldURI);
            if (oldContentURI == null || oldContentURI.equals(newContentURI)) continue;
            notifications.add(new URIChangeNotification(contentObject, oldContentURI));
        }
        return notifications;
    }

    @Override
    public List<URIChangeNotification> detectChangedURIs(IFile oldFile, IFile newFile) {
        return Collections.emptyList();
    }
}

