/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.jdt.util;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.jdt.internal.Activator;
import org.eclipse.sphinx.jdt.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JavaExtensions {
    public static final String VERSION_1_8 = "1.8";
    public static final String DEFAULT_OUTPUT_FOLDER_NAME = "bin";
    public static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^([a-z][a-z_0-9]*\\.)*[A-Z_]($[A-Z_]|[\\w_])*$");
    private static final String PLUGIN_ID_VERSION_SEPARATOR = "_";

    public static File getFile(IClasspathEntry entry) {
        File _xifexpression = null;
        boolean _exists = entry.getPath().toFile().exists();
        _xifexpression = _exists ? entry.getPath().toFile() : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(entry.getPath()).toFile();
        return _xifexpression;
    }

    public static IJavaProject getJavaProject(String projectName) {
        return JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
    }

    public static IPath getLocation(IPath workspacePath) {
        IResource _findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(workspacePath);
        IPath _location = null;
        if (_findMember != null) {
            _location = _findMember.getLocation();
        }
        return _location;
    }

    public static IPath getPluginInstallLocation() {
        String _path = Platform.getInstallLocation().getURL().getPath();
        return new Path(_path).append("plugins");
    }

    public static String getDevModePluginClasspathRootLocationPostfix() {
        return DEFAULT_OUTPUT_FOLDER_NAME;
    }

    public static boolean isInstalledPluginClasspathRootLocationOf(String pluginId, IPath classpathLocation) {
        boolean _xblockexpression = false;
        Assert.isNotNull((Object)classpathLocation);
        _xblockexpression = JavaExtensions.getPluginInstallLocation().isPrefixOf(classpathLocation) && classpathLocation.lastSegment().split(PLUGIN_ID_VERSION_SEPARATOR)[0].equals(pluginId);
        return _xblockexpression;
    }

    public static boolean isDevModePluginClasspathLocationOf(String pluginId, IPath classpathLocation) {
        boolean _xblockexpression = false;
        Assert.isNotNull((Object)classpathLocation);
        _xblockexpression = classpathLocation.toString().contains(new Path(pluginId).append(JavaExtensions.getDevModePluginClasspathRootLocationPostfix()).toString());
        return _xblockexpression;
    }

    public static Bundle getBundle(URL pluginClasspathRootLocationURL) {
        try {
            Object _xblockexpression = null;
            Assert.isNotNull((Object)pluginClasspathRootLocationURL);
            String _path = pluginClasspathRootLocationURL.getPath();
            Path pluginClasspathRootLocation = new Path(_path);
            boolean _isPrefixOf = JavaExtensions.getPluginInstallLocation().isPrefixOf((IPath)pluginClasspathRootLocation);
            if (_isPrefixOf) {
                return Activator.getContext().getBundle("reference:" + pluginClasspathRootLocationURL);
            }
            boolean _equals = pluginClasspathRootLocation.lastSegment().equals(JavaExtensions.getDevModePluginClasspathRootLocationPostfix());
            if (_equals) {
                BundleContext _context = Activator.getContext();
                URL _uRL = pluginClasspathRootLocation.removeLastSegments(1).toFile().toURI().toURL();
                String _plus = "reference:" + _uRL;
                return _context.getBundle(_plus);
            }
            _xblockexpression = null;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static IPath getPluginClasspathRootLocation(String pluginId) {
        boolean _notEquals;
        Bundle bundle = ExtendedPlatform.loadBundle((String)pluginId);
        boolean bl = _notEquals = !Objects.equal((Object)bundle, null);
        if (_notEquals) {
            try {
                URL classpathRootURL = bundle.getResource("/");
                URL resolvedClasspathRootURL = FileLocator.resolve((URL)classpathRootURL);
                String _path = resolvedClasspathRootURL.getPath();
                return new Path(_path).removeTrailingSeparator();
            }
            catch (Throwable _t) {
                if (_t instanceof IOException) {
                    IOException ex = (IOException)_t;
                    IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex);
                    Activator.getDefault().getLog().log(status);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    public static void validateCompilerCompliance(String compliance) {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install instanceof IVMInstall2) {
            boolean _not;
            String compilerCompliance = JavaExtensions.getCompilerCompliance((IVMInstall2)install, compliance);
            boolean _equals = compilerCompliance.equals(compliance);
            boolean bl = _not = !_equals;
            if (_not) {
                try {
                    float complianceToSet = Float.parseFloat(compliance);
                    float complianceFromVM = Float.parseFloat(compilerCompliance);
                    Assert.isLegal((complianceToSet <= complianceFromVM ? 1 : 0) != 0, (String)NLS.bind((String)Messages.error_JRECompliance_NotCompatible, (Object)compliance, (Object)compilerCompliance));
                }
                catch (Throwable _t) {
                    if (_t instanceof NumberFormatException) {
                        NumberFormatException ex = (NumberFormatException)_t;
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    private static String getCompilerCompliance(IVMInstall2 vmInstall, String defaultCompliance) {
        Assert.isNotNull((Object)vmInstall);
        String version = vmInstall.getJavaVersion();
        boolean _equals = Objects.equal((Object)version, null);
        if (_equals) {
            return defaultCompliance;
        }
        boolean _startsWith = version.startsWith(VERSION_1_8);
        if (_startsWith) {
            return VERSION_1_8;
        }
        boolean _startsWith_1 = version.startsWith("1.7");
        if (_startsWith_1) {
            return "1.7";
        }
        boolean _startsWith_2 = version.startsWith("1.6");
        if (_startsWith_2) {
            return "1.6";
        }
        boolean _startsWith_3 = version.startsWith("1.5");
        if (_startsWith_3) {
            return "1.5";
        }
        boolean _startsWith_4 = version.startsWith("1.4");
        if (_startsWith_4) {
            return "1.4";
        }
        boolean _startsWith_5 = version.startsWith("1.3");
        if (_startsWith_5) {
            return "1.3";
        }
        boolean _startsWith_6 = version.startsWith("1.2");
        if (_startsWith_6) {
            return "1.3";
        }
        boolean _startsWith_7 = version.startsWith("1.1");
        if (_startsWith_7) {
            return "1.3";
        }
        return defaultCompliance;
    }
}

