/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.validation.ui.SphinxValidationUiActivator;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerNode;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public abstract class MarkerSelectionProviderAction
extends SelectionProviderAction {
    public MarkerSelectionProviderAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    IMarker[] getSelectedMarkers() {
        return this.getSelectedMarkers(this.getStructuredSelection());
    }

    IMarker[] getSelectedMarkers(IStructuredSelection structured) {
        Object[] selection = structured.toArray();
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Object object = element;
            if (!(object instanceof MarkerNode)) {
                return new IMarker[0];
            }
            MarkerNode marker = (MarkerNode)object;
            if (marker.isConcrete()) {
                markers.add(((ConcreteMarker)object).getMarker());
            }
            ++n2;
        }
        return markers.toArray(new IMarker[markers.size()]);
    }

    IMarker getSelectedMarker() {
        ConcreteMarker selection = (ConcreteMarker)this.getStructuredSelection().getFirstElement();
        return selection.getMarker();
    }

    void execute(IUndoableOperation operation, String title, IProgressMonitor monitor, IAdaptable uiInfo) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(operation, monitor, uiInfo);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                ErrorDialog.openError((Shell)WorkspaceUndoUtil.getShell((IAdaptable)uiInfo), (String)title, null, (IStatus)((CoreException)e.getCause()).getStatus());
            }
            PlatformLogUtil.logAsError((Plugin)SphinxValidationUiActivator.getDefault(), (Object)(String.valueOf(title) + (Object)((Object)e)));
        }
    }
}

