/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAst;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.WikitextLinkedNamesAssistProposal;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IQuickAssistComputer;

public class WikitextQuickRenameComputer
implements IQuickAssistComputer {
    public IStatus computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (!(context.getAstSelection().getCovering() instanceof WikitextAstNode)) {
            return Status.OK_STATUS;
        }
        WikitextAstNode node = (WikitextAstNode)context.getAstSelection().getCovering();
        if (node.getNodeType() == WikitextAst.NodeType.LABEL) {
            WikitextAstNode candidate = node;
            block0: while (candidate != null) {
                block1: for (Object attachment : candidate.getAttachments()) {
                    if (!(attachment instanceof WikitextNameAccess)) continue;
                    WikitextNameAccess access = (WikitextNameAccess)attachment;
                    while (access != null) {
                        if (access.getSegmentName() == null) continue block1;
                        if (access.getNameNode() == node) {
                            this.addAccessAssistProposals(context, access, proposals);
                            break block0;
                        }
                        access = null;
                    }
                }
                candidate = candidate.getWikitextParent();
            }
        }
        return Status.OK_STATUS;
    }

    protected void addAccessAssistProposals(AssistInvocationContext context, WikitextNameAccess access, AssistProposalCollector proposals) {
        ImList accessList = access.getAllInUnit();
        proposals.add((IAssistCompletionProposal)new WikitextLinkedNamesAssistProposal(1, context, access));
    }
}

