/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.http.MimeTypes;
import org.eclipse.statet.rhelp.core.http.ResourceHandler;

@NonNullByDefault
public class SimpleResourceHandler
implements ResourceHandler {
    private final MimeTypes defaultMimeTypes;
    private @Nullable MimeTypes specialMimeTypes;
    private @Nullable String cacheControl;

    public SimpleResourceHandler(MimeTypes mimeTypes) {
        this.defaultMimeTypes = mimeTypes;
    }

    @Override
    public void setSpecialMimeTypes(MimeTypes types) {
        this.specialMimeTypes = types;
    }

    private @Nullable String getMimeType(String fileName) {
        String type = null;
        if (this.specialMimeTypes != null) {
            type = this.specialMimeTypes.getMimeType(fileName);
        }
        if (type == null) {
            type = this.defaultMimeTypes.getMimeType(fileName);
        }
        return type;
    }

    @Override
    public void setCacheControl(String value) {
        this.cacheControl = value;
    }

    @Override
    public void doGet(Path file, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            String cacheControl;
            in.available();
            byte[] buffer = new byte[1024];
            String mimeType = this.getMimeType(file.getFileName().toString());
            if (mimeType != null) {
                resp.setContentType(mimeType);
            }
            if ((cacheControl = this.cacheControl) != null) {
                resp.setHeader("Cache-Control", cacheControl);
            }
            ServletOutputStream outputStream = resp.getOutputStream();
            int n = 0;
            while ((n = in.read(buffer, 0, 1024)) >= 0) {
                outputStream.write(buffer, 0, n);
            }
            outputStream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

