/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.eclient.graphics;

import org.eclipse.statet.ecommons.collections.IntHashMap;
import org.eclipse.statet.ecommons.collections.IntMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    private final Display display;
    private final IntHashMap<Color> colors = new IntHashMap(127);

    public ColorManager(Display display) {
        this.display = display;
    }

    public synchronized Color getColor(int rgb) {
        Color color = (Color)this.colors.get(rgb);
        if (color == null) {
            color = new Color((Device)this.display, rgb & 0xFF, rgb >>> 8 & 0xFF, rgb >>> 16 & 0xFF);
            this.colors.put(rgb, (Object)color);
        }
        return color;
    }

    public void dispose() {
        for (IntMap.IntEntry entry : this.colors.entryIntSet()) {
            ((Color)entry.getValue()).dispose();
        }
        this.colors.clear();
    }
}

