/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.List;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.jcommons.collections.ImList;

public class DocProcessingToolOperationIterator
implements Comparable<DocProcessingToolOperationIterator> {
    public static final byte PRE = 1;
    public static final byte MAIN = 2;
    public static final byte POST = 3;
    private final ImList<DocProcessingToolConfig.StepConfig> steps;
    private int stepIdx;
    private DocProcessingToolConfig.StepConfig stepConfig;
    private byte stepPart;
    private List<DocProcessingOperation> stepPartList;
    private int stepPartIdx;
    private DocProcessingOperation operation;

    public DocProcessingToolOperationIterator(ImList<DocProcessingToolConfig.StepConfig> steps) {
        this.steps = steps;
        this.reset();
    }

    @Override
    public int compareTo(DocProcessingToolOperationIterator other) {
        int diff = this.stepIdx - other.stepIdx;
        if (diff == 0 && (diff = this.stepPart - other.stepPart) == 0) {
            diff = this.stepPartIdx - other.stepPartIdx;
        }
        return diff;
    }

    public void reset() {
        this.stepIdx = -1;
        this.stepConfig = null;
        this.stepPart = (byte)-1;
        this.stepPartList = null;
        this.stepPartIdx = -1;
        this.operation = null;
    }

    public void reset(DocProcessingToolOperationIterator other) {
        this.stepIdx = other.stepIdx;
        this.stepConfig = other.stepConfig;
        this.stepPart = other.stepPart;
        this.stepPartList = other.stepPartList;
        this.stepPartIdx = other.stepPartIdx;
        this.operation = other.operation;
    }

    public boolean hasNext() {
        if (this.stepIdx < 0) {
            return this.nextStep();
        }
        return this.operation != null;
    }

    public boolean next() {
        if (this.stepIdx < 0) {
            return this.nextStep();
        }
        if (this.stepIdx == Integer.MAX_VALUE) {
            return false;
        }
        this.operation = null;
        return this.nextInPart() || this.nextPart() || this.nextStep();
    }

    private boolean nextStep() {
        while (++this.stepIdx < this.steps.size()) {
            this.stepConfig = (DocProcessingToolConfig.StepConfig)this.steps.get(this.stepIdx);
            if (!this.stepConfig.isRun() || !this.nextPart()) continue;
            return true;
        }
        this.stepIdx = Integer.MAX_VALUE;
        this.stepConfig = null;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nextPart() {
        block6: while (true) {
            this.stepPart = (byte)(this.stepPart + 1);
            switch (this.stepPart) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    this.stepPartList = this.stepConfig.getPre();
                    if (!this.nextInPart()) continue block6;
                    return true;
                }
                case 2: {
                    this.operation = this.stepConfig.getOperation();
                    if (this.operation == null) continue block6;
                    return true;
                }
                case 3: {
                    this.stepPartList = this.stepConfig.getPost();
                    if (this.nextInPart()) return true;
                    continue block6;
                }
            }
            break;
        }
        this.stepPart = (byte)-1;
        return false;
    }

    private boolean nextInPart() {
        if (this.stepPartList != null) {
            if (++this.stepPartIdx < this.stepPartList.size()) {
                this.operation = this.stepPartList.get(this.stepPartIdx);
                return true;
            }
            this.stepPartIdx = -1;
            this.stepPartList = null;
        }
        return false;
    }

    public int getStepIdx() {
        return this.stepIdx;
    }

    public DocProcessingToolConfig.StepConfig getStepConfig() {
        return this.stepConfig;
    }

    public byte getStepPart() {
        return this.stepPart;
    }

    public DocProcessingOperation getOperation() {
        return this.operation;
    }
}

