/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ReplaceWindowFuncCallsWithCRVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubstituteExpressionVisitor;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowFunctionNode;

class WindowResultSetNode
extends SingleChildResultSetNode {
    FromTable parent;
    List<WindowFunctionNode> windowFuncCalls;
    WindowDefinitionNode wdn;

    WindowResultSetNode(ResultSetNode resultSetNode, WindowDefinitionNode windowDefinitionNode, List<WindowFunctionNode> list, int n, ContextManager contextManager) throws StandardException {
        super(resultSetNode, null, contextManager);
        this.wdn = windowDefinitionNode;
        this.windowFuncCalls = list;
        this.setLevel(n);
        this.parent = this;
        ResultColumnList resultColumnList = this.childResult.getResultColumns().copyListAndObjects();
        this.setResultColumns(this.childResult.getResultColumns());
        this.childResult.setResultColumns(resultColumnList);
        this.addNewPRNode();
        this.addNewColumns();
    }

    private void addNewPRNode() throws StandardException {
        QueryTreeNode queryTreeNode2;
        Object object2;
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        for (Object object2 : this.getResultColumns()) {
            if (((ResultColumn)object2).isGenerated()) continue;
            resultColumnList.addElement(object2);
        }
        resultColumnList.copyOrderBySelect(this.getResultColumns());
        this.parent = new ProjectRestrictNode(this, resultColumnList, null, null, null, null, null, this.getContextManager());
        this.childResult.setResultColumns(new ResultColumnList(this.getContextManager()));
        this.setResultColumns(new ResultColumnList(this.getContextManager()));
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.parent.getResultColumns().accept(collectNodesVisitor);
        object2 = new ArrayList();
        for (QueryTreeNode queryTreeNode2 : collectNodesVisitor.getList()) {
            if (this.colRefAlreadySeen((List<ValueNode>)object2, (ColumnReference)queryTreeNode2)) continue;
            ((ArrayList)object2).add(queryTreeNode2);
        }
        CollectNodesVisitor<VirtualColumnNode> collectNodesVisitor2 = new CollectNodesVisitor<VirtualColumnNode>(VirtualColumnNode.class);
        this.parent.getResultColumns().accept(collectNodesVisitor2);
        ((ArrayList)object2).addAll(collectNodesVisitor2.getList());
        queryTreeNode2 = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.getResultColumns();
        Iterator iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            ValueNode valueNode = (ValueNode)iterator.next();
            ResultColumn resultColumn = new ResultColumn("##UnWindowingColumn", valueNode, this.getContextManager());
            ((QueryTreeNodeVector)queryTreeNode2).addElement(resultColumn);
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumn.setVirtualColumnId(((QueryTreeNodeVector)queryTreeNode2).size());
            ResultColumn resultColumn2 = new ResultColumn("##UnWindowingColumn", valueNode, this.getContextManager());
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            VirtualColumnNode virtualColumnNode = new VirtualColumnNode(this, resultColumn2, resultColumnList2.size(), this.getContextManager());
            SubstituteExpressionVisitor substituteExpressionVisitor = new SubstituteExpressionVisitor(valueNode, virtualColumnNode, null);
            this.parent.getResultColumns().accept(substituteExpressionVisitor);
        }
    }

    private boolean colRefAlreadySeen(List<ValueNode> list, ColumnReference columnReference) throws StandardException {
        for (ValueNode valueNode : list) {
            ColumnReference columnReference2 = (ColumnReference)valueNode;
            if (!columnReference2.isEquivalent(columnReference)) continue;
            return true;
        }
        return false;
    }

    private void addNewColumns() throws StandardException {
        ResultColumnList resultColumnList = this.childResult.getResultColumns();
        ResultColumnList resultColumnList2 = this.getResultColumns();
        ReplaceWindowFuncCallsWithCRVisitor replaceWindowFuncCallsWithCRVisitor = new ReplaceWindowFuncCallsWithCRVisitor(new ResultColumnList(this.getContextManager()), ((FromTable)this.childResult).getTableNumber(), ResultSetNode.class);
        this.parent.getResultColumns().accept(replaceWindowFuncCallsWithCRVisitor);
        for (WindowFunctionNode windowFunctionNode : this.windowFuncCalls) {
            WindowDefinitionNode windowDefinitionNode = (WindowDefinitionNode)windowFunctionNode.getWindow();
            if (windowDefinitionNode != this.wdn) continue;
            ResultColumn resultColumn = new ResultColumn("##winFuncResult", windowFunctionNode.getNewNullResultExpression(), this.getContextManager());
            resultColumn.markGenerated();
            resultColumn.bindResultColumnToExpression();
            resultColumnList.addElement(resultColumn);
            resultColumn.setVirtualColumnId(resultColumnList.size());
            ColumnReference columnReference = new ColumnReference(resultColumn.getName(), null, this.getContextManager());
            columnReference.setSource(resultColumn);
            columnReference.setNestingLevel(this.getLevel());
            columnReference.setSourceLevel(this.getLevel());
            columnReference.markGeneratedToReplaceWindowFunctionCall();
            ResultColumn resultColumn2 = new ResultColumn(resultColumn.getColumnName(), (ValueNode)columnReference, this.getContextManager());
            resultColumn2.markGenerated();
            resultColumn2.bindResultColumnToExpression();
            resultColumnList2.addElement(resultColumn2);
            resultColumn2.setVirtualColumnId(resultColumnList2.size());
            columnReference = windowFunctionNode.getGeneratedRef();
            if (columnReference == null) continue;
            columnReference.setSource(resultColumn2);
        }
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n2 = this.getResultColumns().size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
        for (n = n2 - 1; n >= 0; --n) {
            ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(n);
            ValueNode valueNode = resultColumn.getExpression();
            if (resultColumn.isGenerated() && valueNode instanceof ColumnReference && ((ColumnReference)valueNode).getGeneratedToReplaceWindowFunctionCall()) continue;
            formatableBitSet.set(n);
        }
        n = activationClassBuilder.addItem(formatableBitSet);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        methodBuilder.push(activationClassBuilder.addItem(this.getResultColumns().buildRowTemplate()));
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(n);
        methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getWindowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 8);
    }

    final FromTable getParent() {
        return this.parent;
    }

    @Override
    public void printSubNodes(int n) {
    }
}

