/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

public abstract class FilterDirectory
extends Directory {
    protected final Directory in;

    public static Directory unwrap(Directory dir) {
        while (dir instanceof FilterDirectory) {
            dir = ((FilterDirectory)dir).in;
        }
        return dir;
    }

    protected FilterDirectory(Directory in) {
        this.in = in;
    }

    public final Directory getDelegate() {
        return this.in;
    }

    @Override
    public String[] listAll() throws IOException {
        return this.in.listAll();
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.in.deleteFile(name);
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.in.fileLength(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.in.createOutput(name, context);
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        return this.in.createTempOutput(prefix, suffix, context);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.in.sync(names);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.in.rename(source, dest);
    }

    @Override
    public void syncMetaData() throws IOException {
        this.in.syncMetaData();
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        return this.in.openInput(name, context);
    }

    @Override
    public Lock obtainLock(String name) throws IOException {
        return this.in.obtainLock(name);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.in.toString() + ")";
    }

    @Override
    public Set<String> getPendingDeletions() throws IOException {
        return super.getPendingDeletions();
    }
}

