/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.rsource.ScopeFactory;
import org.eclipse.statet.r.core.rsource.ast.Block;
import org.eclipse.statet.r.core.rsource.ast.CForLoop;
import org.eclipse.statet.r.core.rsource.ast.CIfElse;
import org.eclipse.statet.r.core.rsource.ast.CRepeatLoop;
import org.eclipse.statet.r.core.rsource.ast.CWhileLoop;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.FDef;
import org.eclipse.statet.r.core.rsource.ast.GenericVisitor;
import org.eclipse.statet.r.core.rsource.ast.Group;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.rsource.ast.SubIndexed;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RSourceIndenter {
    private IndentUtil util;
    private final RHeuristicTokenScanner scanner;
    private final ComputeIndentVisitor computeVisitor;
    private AbstractDocument document;
    private AstNode rootNode;
    private RCodeStyleSettings codeStyle;
    private int refLine;
    private int firstLine;
    private int lastLine;
    private int[] lineOffsets;
    private int[] lineLevels;
    private ScopeFactory factory;

    public RSourceIndenter(RHeuristicTokenScanner scanner) {
        this.scanner = scanner;
        this.computeVisitor = new ComputeIndentVisitor();
    }

    public RSourceIndenter(RHeuristicTokenScanner scanner, IRCoreAccess access) {
        this(scanner);
        this.setup(access);
    }

    public void setup(IRCoreAccess access) {
        this.codeStyle = access.getRCodeStyle();
    }

    public void clear() {
        this.document = null;
        this.rootNode = null;
        this.codeStyle = null;
        this.util = null;
        this.lineLevels = null;
    }

    public int getNewIndentColumn(int line) throws BadLocationException {
        return this.getNewIndentColumn(line, this.document.getLineOffset(line));
    }

    private int getNewIndentColumn(int line, int lineOffset) throws BadLocationException {
        if (this.getDocumentChar(lineOffset) == 35 && this.getDocumentChar(lineOffset + 1) != 35) {
            return 0;
        }
        return this.lineLevels[line];
    }

    public int getNewIndentOffset(int line) {
        try {
            return this.util.getIndentedOffsetAt(line, this.lineLevels[line]);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public TextEdit getIndentEdits(AbstractDocument document, AstNode root, int codeOffset, int firstLine, int lastLine) throws CoreException {
        try {
            this.document = document;
            this.rootNode = root;
            this.computeIndent(codeOffset, firstLine, lastLine);
            return this.createEdits();
        }
        catch (BadLocationException e) {
            throw this.createFailedException(e);
        }
    }

    protected void computeIndent(int codeOffset, int firstLine, int lastLine) throws BadLocationException {
        try {
            try {
                int refOffset;
                this.codeStyle.getReadLock().lock();
                this.util = new IndentUtil((IDocument)this.document, (IIndentSettings)this.codeStyle);
                this.firstLine = firstLine;
                this.lastLine = lastLine;
                this.scanner.configure((IDocument)this.document);
                this.refLine = -1;
                int cand = this.firstLine;
                if (cand > 0 && (refOffset = this.scanner.findAnyNonBlankBackward(this.document.getLineOffset(cand), -2, true)) >= codeOffset && (this.document.getChar(refOffset = this.scanner.findAnyNonBlankForward(this.document.getLineOffset(cand = this.document.getLineOfOffset(refOffset)), refOffset + 1, true)) != '#' || this.document.getChar(refOffset + 1) == '#')) {
                    this.refLine = cand;
                }
                int startLine = this.refLine >= 0 ? this.refLine : this.firstLine;
                int count = this.document.getNumberOfLines(0, this.document.getLineOffset(this.lastLine));
                this.lineLevels = new int[count + 2];
                Arrays.fill(this.lineLevels, -1);
                this.lineOffsets = new int[count + 3];
                int i = startLine;
                while (i < count) {
                    this.lineOffsets[i] = this.document.getLineOffset(i);
                    ++i;
                }
                this.lineOffsets[count] = count < this.document.getNumberOfLines() ? this.document.getLineOffset(count) : this.document.getLength();
                this.lineOffsets[count] = Integer.MAX_VALUE;
                this.lineOffsets[count + 1] = Integer.MAX_VALUE;
                this.lineOffsets[count + 2] = Integer.MAX_VALUE;
                this.factory = new ScopeFactory(this.util, this.codeStyle, this.document);
                this.computeVisitor.computeIndent();
                this.correctLevels();
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof BadLocationException) {
                    throw (BadLocationException)targetException;
                }
                RCorePlugin.logError("Unexpected error while indent sources", e);
                if (this.codeStyle != null) {
                    this.codeStyle.getReadLock().unlock();
                    this.codeStyle = null;
                }
                this.factory = null;
                this.lineOffsets = null;
            }
        }
        finally {
            if (this.codeStyle != null) {
                this.codeStyle.getReadLock().unlock();
                this.codeStyle = null;
            }
            this.factory = null;
            this.lineOffsets = null;
        }
    }

    protected void correctLevels() throws BadLocationException {
        int shift = 0;
        if (this.refLine >= 0) {
            this.lineLevels[this.refLine] = this.lineLevels[this.refLine];
            shift = this.util.getLineIndent(this.refLine, false)[0] - this.lineLevels[this.refLine];
            int n = this.refLine;
            this.lineLevels[n] = this.lineLevels[n] + shift;
        } else {
            shift = 0;
        }
        int n = this.firstLine;
        this.lineLevels[n] = this.lineLevels[n] + shift;
        if (this.lineLevels[this.firstLine] < 0) {
            shift -= this.lineLevels[this.firstLine];
            this.lineLevels[this.firstLine] = 0;
        }
        int line = this.firstLine + 1;
        while (line <= this.lastLine) {
            int n2 = line;
            this.lineLevels[n2] = this.lineLevels[n2] + shift;
            if (this.lineLevels[line] < 0) {
                this.lineLevels[line] = 0;
            }
            ++line;
        }
    }

    protected MultiTextEdit createEdits() throws BadLocationException, CoreException {
        final MultiTextEdit edits = new MultiTextEdit();
        IndentUtil.IndentEditAction action = new IndentUtil.IndentEditAction(){

            public int getIndentColumn(int line, int lineOffset) throws BadLocationException {
                return RSourceIndenter.this.getNewIndentColumn(line, lineOffset);
            }

            public void doEdit(int line, int offset, int length, StringBuilder text) throws BadLocationException {
                if (text != null) {
                    edits.addChild((TextEdit)new ReplaceEdit(offset, length, text.toString()));
                }
            }
        };
        this.util.changeIndent(this.firstLine, this.lastLine, action);
        return edits;
    }

    protected final int getDocumentChar(int idx) throws BadLocationException {
        if (idx >= 0 && idx < this.document.getLength()) {
            return this.document.getChar(idx);
        }
        return -1;
    }

    protected CoreException createFailedException(Throwable e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", -1, "Indentation failed", e));
    }

    private class ComputeIndentVisitor
    extends GenericVisitor
    implements AstVisitor {
        private int startOffset;
        private int stopOffset;
        private int currentLine;

        private ComputeIndentVisitor() {
        }

        void computeIndent() throws InvocationTargetException {
            try {
                this.currentLine = RSourceIndenter.this.refLine >= 0 ? RSourceIndenter.this.refLine : RSourceIndenter.this.firstLine;
                this.startOffset = RSourceIndenter.this.document.getLineOffset(this.currentLine);
                this.stopOffset = RSourceIndenter.this.document.getLineOffset(RSourceIndenter.this.lastLine) + RSourceIndenter.this.document.getLineLength(RSourceIndenter.this.lastLine);
                RSourceIndenter.this.rootNode.accept((AstVisitor)this);
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private final boolean checkOffset(int offset) {
            if (offset >= RSourceIndenter.this.lineOffsets[this.currentLine]) {
                do {
                    ((RSourceIndenter)RSourceIndenter.this).lineLevels[this.currentLine] = RSourceIndenter.this.factory.getIndent(this.currentLine);
                } while (offset >= RSourceIndenter.this.lineOffsets[++this.currentLine]);
                return true;
            }
            return false;
        }

        private void checkBeforeOffset(int offset) {
            if (offset >= RSourceIndenter.this.lineOffsets[this.currentLine + 1]) {
                int level = RSourceIndenter.this.factory.getIndent(this.currentLine);
                do {
                    ((RSourceIndenter)RSourceIndenter.this).lineLevels[this.currentLine++] = level;
                } while (offset >= RSourceIndenter.this.lineOffsets[this.currentLine + 1]);
            }
        }

        private boolean checkNode(RAstNode node) throws InvocationTargetException {
            int offset = node.getStartOffset();
            if (this.checkOffset(offset)) {
                return node.getEndOffset() >= RSourceIndenter.this.lineOffsets[this.currentLine];
            }
            return node.getEndOffset() >= this.startOffset && offset <= this.stopOffset;
        }

        private final void checkExprListChilds(RAstNode node) throws InvocationTargetException {
            try {
                int count = node.getChildCount();
                int i = 0;
                while (i < count) {
                    RAstNode child = node.getChild(i);
                    RSourceIndenter.this.factory.createCommonExprScope(child.getStartOffset(), child);
                    child.acceptInR(this);
                    RSourceIndenter.this.factory.leaveScope();
                    ++i;
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        public void visit(AstNode node) throws InvocationTargetException {
            if (node.getEndOffset() >= this.startOffset && node.getStartOffset() <= this.stopOffset) {
                if (node instanceof RAstNode) {
                    ((RAstNode)node).acceptInR(this);
                } else {
                    node.acceptInChildren((AstVisitor)this);
                }
            }
        }

        @Override
        public void visit(SourceComponent node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createSourceScope(0, node);
                if (node.getEndOffset() >= this.startOffset && node.getStartOffset() <= this.stopOffset) {
                    this.checkExprListChilds(node);
                }
                this.checkOffset(0x7FFFFFFD);
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(Block node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createBlockScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    RSourceIndenter.this.factory.updateEnterBrackets();
                    this.checkExprListChilds(node);
                    this.checkBeforeOffset(node.getEndOffset());
                    RSourceIndenter.this.factory.updateLeaveBrackets();
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(Group node) throws InvocationTargetException {
            try {
                if (this.checkNode(node)) {
                    RSourceIndenter.this.factory.createGroupContScope(node.getStartOffset() + 1, node.getExprChild());
                    node.getExprChild().acceptInR(this);
                    this.checkBeforeOffset(node.getEndOffset());
                    this.checkOffset(node.getEndOffset());
                    RSourceIndenter.this.factory.leaveScope();
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private final void checkControlCondChild(int open, RAstNode child, int close) throws InvocationTargetException {
            try {
                if (open >= 0) {
                    this.checkOffset(open);
                    RSourceIndenter.this.factory.createControlCondScope(open + 1, child);
                    child.acceptInR(this);
                    this.checkBeforeOffset(close);
                    this.checkOffset(close);
                    RSourceIndenter.this.factory.leaveScope();
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private final void checkControlContChild(RAstNode child) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createControlContScope(child.getStartOffset(), child);
                child.acceptInR(this);
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(CIfElse node) throws InvocationTargetException {
            try {
                boolean inElseIf = false;
                if (node.getRParent().getNodeType() == NodeType.C_IF && ((CIfElse)node.getParent()).getElseChild() == node) {
                    RSourceIndenter.this.factory.leaveScope();
                    inElseIf = true;
                } else {
                    RSourceIndenter.this.factory.createControlScope(node.getStartOffset(), node);
                }
                if (this.checkNode(node)) {
                    this.checkControlCondChild(node.getCondOpenOffset(), node.getCondChild(), node.getCondCloseOffset());
                    this.checkControlContChild(node.getThenChild());
                    if (node.hasElse()) {
                        this.checkOffset(node.getElseOffset());
                        this.checkControlContChild(node.getElseChild());
                    }
                    this.checkOffset(node.getEndOffset());
                }
                if (inElseIf) {
                    RSourceIndenter.this.factory.createDummy();
                } else {
                    RSourceIndenter.this.factory.leaveScope();
                }
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(CForLoop node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createControlScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    this.checkControlCondChild(node.getCondOpenOffset(), node.getCondChild(), node.getCondCloseOffset());
                    this.checkControlContChild(node.getContChild());
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(CWhileLoop node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createControlScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    this.checkControlCondChild(node.getCondOpenOffset(), node.getCondChild(), node.getCondCloseOffset());
                    this.checkControlContChild(node.getContChild());
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(CRepeatLoop node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createControlScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    this.checkControlContChild(node.getContChild());
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private final void checkArglist(RAstNode node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createArglistScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    node.acceptInRChildren(this);
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private final void checkFDeflist(RAstNode node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createFDeflistScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    node.acceptInRChildren(this);
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        private final void checkArg(RAstNode node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createCommonExprScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    node.acceptInRChildren(this);
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(FDef node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createFDefScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    node.getArgsChild().acceptInR(this);
                    RSourceIndenter.this.factory.updateEnterFDefBody();
                    this.checkControlContChild(node.getContChild());
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(FDef.Args node) throws InvocationTargetException {
            this.checkFDeflist(node);
        }

        @Override
        public void visit(FDef.Arg node) throws InvocationTargetException {
            this.checkArg(node);
        }

        @Override
        public void visit(FCall node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createFCallScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    node.getRefChild().acceptInR(this);
                    node.getArgsChild().acceptInR(this);
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(FCall.Args node) throws InvocationTargetException {
            this.checkArglist(node);
        }

        @Override
        public void visit(FCall.Arg node) throws InvocationTargetException {
            this.checkArg(node);
        }

        @Override
        public void visit(SubIndexed node) throws InvocationTargetException {
            try {
                RSourceIndenter.this.factory.createFCallScope(node.getStartOffset(), node);
                if (this.checkNode(node)) {
                    node.getRefChild().acceptInR(this);
                    node.getArgsChild().acceptInR(this);
                    this.checkOffset(node.getEndOffset());
                }
                RSourceIndenter.this.factory.leaveScope();
            }
            catch (BadLocationException e) {
                throw new InvocationTargetException(e);
            }
        }

        @Override
        public void visit(SubIndexed.Args node) throws InvocationTargetException {
            this.checkArglist(node);
        }

        @Override
        public void visit(SubIndexed.Arg node) throws InvocationTargetException {
            this.checkArg(node);
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (this.checkNode(node)) {
                node.acceptInRChildren(this);
                this.checkOffset(node.getEndOffset());
            }
        }
    }
}

