/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;
import org.eclipse.statet.r.core.rsource.ast.SpecItem;

public final class FCall
extends RAstNode {
    final Expression refExpr = new Expression();
    int argsOpenOffset = Integer.MIN_VALUE;
    final Args args = new Args(this);
    int argsCloseOffset = Integer.MIN_VALUE;

    FCall() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.F_CALL;
    }

    @Override
    public final RTerminal getOperator(int index) {
        return null;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.refExpr.node;
            }
            case 1: {
                return this.args;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        return new RAstNode[]{this.refExpr.node, this.args};
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.refExpr.node == child) {
            return 0;
        }
        if (this.args == child) {
            return 1;
        }
        return -1;
    }

    public final RAstNode getRefChild() {
        return this.refExpr.node;
    }

    public final int getArgsOpenOffset() {
        return this.argsOpenOffset;
    }

    public final Args getArgsChild() {
        return this.args;
    }

    public final int getArgsCloseOffset() {
        return this.argsCloseOffset;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.refExpr.node.acceptInR(visitor);
        this.args.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.refExpr.node);
        visitor.visit((AstNode)this.args);
    }

    @Override
    final Expression getExpr(RAstNode child) {
        if (this.refExpr.node == child) {
            return this.refExpr;
        }
        return null;
    }

    @Override
    final Expression getLeftExpr() {
        return this.refExpr;
    }

    @Override
    final Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (element.getNodeType() != NodeType.F_CALL) {
            return false;
        }
        RAstNode otherExprNode = ((FCall)element).refExpr.node;
        return this.refExpr.node == otherExprNode || this.refExpr.node != null && this.refExpr.node.equalsSingle(otherExprNode);
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (expr == this.refExpr) {
            return 70416;
        }
        throw new IllegalArgumentException();
    }

    final void updateStartOffset() {
        this.startOffset = this.refExpr.node.startOffset;
    }

    @Override
    final void updateEndOffset() {
        this.endOffset = this.argsCloseOffset != Integer.MIN_VALUE ? this.argsCloseOffset + 1 : this.args.endOffset;
    }

    public static final class Arg
    extends SpecItem {
        Arg(Args parent) {
            this.rParent = parent;
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.F_CALL_ARG;
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.F_CALL_ARG;
        }
    }

    public static final class Args
    extends RAstNode {
        final List<Arg> specs;
        final IntList sepList;

        Args(FCall parent) {
            this.rParent = parent;
            this.specs = new ArrayList<Arg>(1);
            this.sepList = new IntArrayList(1);
        }

        @Override
        public final NodeType getNodeType() {
            return NodeType.F_CALL_ARGS;
        }

        @Override
        public final RTerminal getOperator(int index) {
            return null;
        }

        public int getSeparatorOffset(int index) {
            return this.sepList.getAt(index);
        }

        @Override
        public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
            visitor.visit(this);
        }

        @Override
        public final boolean hasChildren() {
            return !this.specs.isEmpty();
        }

        @Override
        public final int getChildCount() {
            return this.specs.size();
        }

        @Override
        public final Arg getChild(int index) {
            return this.specs.get(index);
        }

        public final Arg[] getChildren() {
            return this.specs.toArray(new Arg[this.specs.size()]);
        }

        @Override
        public final int getChildIndex(AstNode child) {
            int i = this.specs.size() - 1;
            while (i >= 0) {
                if (this.specs.get(i) == child) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        @Override
        public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
            this.acceptChildren(visitor, this.specs);
        }

        public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
            for (RAstNode rAstNode : this.specs) {
                visitor.visit((AstNode)rAstNode);
            }
        }

        @Override
        final Expression getExpr(RAstNode child) {
            return null;
        }

        @Override
        final Expression getLeftExpr() {
            return null;
        }

        @Override
        final Expression getRightExpr() {
            return null;
        }

        @Override
        public final boolean equalsSingle(RAstNode element) {
            return element.getNodeType() == NodeType.F_CALL_ARGS;
        }

        @Override
        final int getMissingExprStatus(Expression expr) {
            throw new IllegalArgumentException();
        }

        @Override
        final void updateEndOffset() {
        }
    }
}

