/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.util.EnumMap;
import java.util.EnumSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.statet.nico.core.runtime.SubmitType;

public class ToolStreamMonitor
implements IStreamMonitor {
    private final EnumMap<SubmitType, ListenerList> fListeners = new EnumMap(SubmitType.class);
    private int fCurrentMeta;

    public ToolStreamMonitor() {
        for (SubmitType type : EnumSet.allOf(SubmitType.class)) {
            this.fListeners.put(type, new ListenerList(1));
        }
    }

    public void addListener(IStreamListener listener) {
        this.addListener(listener, SubmitType.getDefaultSet());
    }

    public void addListener(IStreamListener listener, EnumSet<SubmitType> types) {
        SubmitType[] submitTypeArray = SubmitType.values();
        int n = submitTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubmitType type = submitTypeArray[n2];
            ListenerList list = this.fListeners.get((Object)type);
            if (types.contains((Object)type)) {
                list.add((Object)listener);
            } else {
                list.remove((Object)listener);
            }
            ++n2;
        }
    }

    public void removeListener(IStreamListener listener) {
        for (ListenerList list : this.fListeners.values()) {
            list.remove((Object)listener);
        }
    }

    public String getContents() {
        return "";
    }

    public void append(String text, SubmitType type, int meta) {
        ListenerList list = this.fListeners.get((Object)type);
        this.fCurrentMeta = meta;
        Object[] objectArray = list.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            IStreamListener listener = (IStreamListener)obj;
            listener.streamAppended(text, (IStreamMonitor)this);
            ++n2;
        }
    }

    public int getMeta() {
        return this.fCurrentMeta;
    }

    void dispose() {
        this.fListeners.clear();
    }
}

